<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contexts StructType
 * @subpackage Structs
 */
class Contexts extends AbstractStructBase
{
    /**
     * The Context
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SuppressionListContext[]
     */
    public $Context;
    /**
     * Constructor method for Contexts
     * @uses Contexts::setContext()
     * @param \App\Library\ExactTarget\StructType\SuppressionListContext[] $context
     */
    public function __construct(array $context = array())
    {
        $this
            ->setContext($context);
    }
    /**
     * Get Context value
     * @return \App\Library\ExactTarget\StructType\SuppressionListContext[]|null
     */
    public function getContext()
    {
        return $this->Context;
    }
    /**
     * Set Context value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SuppressionListContext[] $context
     * @return \App\Library\ExactTarget\StructType\Contexts
     */
    public function setContext(array $context = array())
    {
        foreach ($context as $contextsContextItem) {
            // validation for constraint: itemType
            if (!$contextsContextItem instanceof \App\Library\ExactTarget\StructType\SuppressionListContext) {
                throw new \InvalidArgumentException(sprintf('The Context property can only contain items of \App\Library\ExactTarget\StructType\SuppressionListContext, "%s" given', is_object($contextsContextItem) ? get_class($contextsContextItem) : gettype($contextsContextItem)), __LINE__);
            }
        }
        $this->Context = $context;
        return $this;
    }
    /**
     * Add item to Context value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SuppressionListContext $item
     * @return \App\Library\ExactTarget\StructType\Contexts
     */
    public function addToContext(\App\Library\ExactTarget\StructType\SuppressionListContext $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\SuppressionListContext) {
            throw new \InvalidArgumentException(sprintf('The Context property can only contain items of \App\Library\ExactTarget\StructType\SuppressionListContext, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Context[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Contexts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
