<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactEvent StructType
 * @subpackage Structs
 */
class ContactEvent extends APIObject
{
    /**
     * The ContactID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ContactID;
    /**
     * The ContactKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactKey;
    /**
     * The EventDefinitionKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventDefinitionKey;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Data
     */
    public $Data;
    /**
     * Constructor method for ContactEvent
     * @uses ContactEvent::setContactID()
     * @uses ContactEvent::setContactKey()
     * @uses ContactEvent::setEventDefinitionKey()
     * @uses ContactEvent::setData()
     * @param int $contactID
     * @param string $contactKey
     * @param string $eventDefinitionKey
     * @param \App\Library\ExactTarget\StructType\Data $data
     */
    public function __construct($contactID = null, $contactKey = null, $eventDefinitionKey = null, \App\Library\ExactTarget\StructType\Data $data = null)
    {
        $this
            ->setContactID($contactID)
            ->setContactKey($contactKey)
            ->setEventDefinitionKey($eventDefinitionKey)
            ->setData($data);
    }
    /**
     * Get ContactID value
     * @return int|null
     */
    public function getContactID()
    {
        return $this->ContactID;
    }
    /**
     * Set ContactID value
     * @param int $contactID
     * @return \App\Library\ExactTarget\StructType\ContactEvent
     */
    public function setContactID($contactID = null)
    {
        // validation for constraint: int
        if (!is_null($contactID) && !is_numeric($contactID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contactID)), __LINE__);
        }
        $this->ContactID = $contactID;
        return $this;
    }
    /**
     * Get ContactKey value
     * @return string|null
     */
    public function getContactKey()
    {
        return $this->ContactKey;
    }
    /**
     * Set ContactKey value
     * @param string $contactKey
     * @return \App\Library\ExactTarget\StructType\ContactEvent
     */
    public function setContactKey($contactKey = null)
    {
        // validation for constraint: string
        if (!is_null($contactKey) && !is_string($contactKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactKey)), __LINE__);
        }
        $this->ContactKey = $contactKey;
        return $this;
    }
    /**
     * Get EventDefinitionKey value
     * @return string|null
     */
    public function getEventDefinitionKey()
    {
        return $this->EventDefinitionKey;
    }
    /**
     * Set EventDefinitionKey value
     * @param string $eventDefinitionKey
     * @return \App\Library\ExactTarget\StructType\ContactEvent
     */
    public function setEventDefinitionKey($eventDefinitionKey = null)
    {
        // validation for constraint: string
        if (!is_null($eventDefinitionKey) && !is_string($eventDefinitionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDefinitionKey)), __LINE__);
        }
        $this->EventDefinitionKey = $eventDefinitionKey;
        return $this;
    }
    /**
     * Get Data value
     * @return \App\Library\ExactTarget\StructType\Data|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param \App\Library\ExactTarget\StructType\Data $data
     * @return \App\Library\ExactTarget\StructType\ContactEvent
     */
    public function setData(\App\Library\ExactTarget\StructType\Data $data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ContactEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
