<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComplexFilterPart StructType
 * @subpackage Structs
 */
class ComplexFilterPart extends FilterPart
{
    /**
     * The LeftOperand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\FilterPart
     */
    public $LeftOperand;
    /**
     * The LogicalOperator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LogicalOperator;
    /**
     * The RightOperand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FilterPart
     */
    public $RightOperand;
    /**
     * The AdditionalOperands
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AdditionalOperands
     */
    public $AdditionalOperands;
    /**
     * Constructor method for ComplexFilterPart
     * @uses ComplexFilterPart::setLeftOperand()
     * @uses ComplexFilterPart::setLogicalOperator()
     * @uses ComplexFilterPart::setRightOperand()
     * @uses ComplexFilterPart::setAdditionalOperands()
     * @param \App\Library\ExactTarget\StructType\FilterPart $leftOperand
     * @param string $logicalOperator
     * @param \App\Library\ExactTarget\StructType\FilterPart $rightOperand
     * @param \App\Library\ExactTarget\StructType\AdditionalOperands $additionalOperands
     */
    public function __construct(\App\Library\ExactTarget\StructType\FilterPart $leftOperand = null, $logicalOperator = null, \App\Library\ExactTarget\StructType\FilterPart $rightOperand = null, \App\Library\ExactTarget\StructType\AdditionalOperands $additionalOperands = null)
    {
        $this
            ->setLeftOperand($leftOperand)
            ->setLogicalOperator($logicalOperator)
            ->setRightOperand($rightOperand)
            ->setAdditionalOperands($additionalOperands);
    }
    /**
     * Get LeftOperand value
     * @return \App\Library\ExactTarget\StructType\FilterPart
     */
    public function getLeftOperand()
    {
        return $this->LeftOperand;
    }
    /**
     * Set LeftOperand value
     * @param \App\Library\ExactTarget\StructType\FilterPart $leftOperand
     * @return \App\Library\ExactTarget\StructType\ComplexFilterPart
     */
    public function setLeftOperand(\App\Library\ExactTarget\StructType\FilterPart $leftOperand = null)
    {
        $this->LeftOperand = $leftOperand;
        return $this;
    }
    /**
     * Get LogicalOperator value
     * @return string
     */
    public function getLogicalOperator()
    {
        return $this->LogicalOperator;
    }
    /**
     * Set LogicalOperator value
     * @uses \App\Library\ExactTarget\EnumType\LogicalOperators::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\LogicalOperators::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $logicalOperator
     * @return \App\Library\ExactTarget\StructType\ComplexFilterPart
     */
    public function setLogicalOperator($logicalOperator = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\LogicalOperators::valueIsValid($logicalOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $logicalOperator, implode(', ', \App\Library\ExactTarget\EnumType\LogicalOperators::getValidValues())), __LINE__);
        }
        $this->LogicalOperator = $logicalOperator;
        return $this;
    }
    /**
     * Get RightOperand value
     * @return \App\Library\ExactTarget\StructType\FilterPart|null
     */
    public function getRightOperand()
    {
        return $this->RightOperand;
    }
    /**
     * Set RightOperand value
     * @param \App\Library\ExactTarget\StructType\FilterPart $rightOperand
     * @return \App\Library\ExactTarget\StructType\ComplexFilterPart
     */
    public function setRightOperand(\App\Library\ExactTarget\StructType\FilterPart $rightOperand = null)
    {
        $this->RightOperand = $rightOperand;
        return $this;
    }
    /**
     * Get AdditionalOperands value
     * @return \App\Library\ExactTarget\StructType\AdditionalOperands|null
     */
    public function getAdditionalOperands()
    {
        return $this->AdditionalOperands;
    }
    /**
     * Set AdditionalOperands value
     * @param \App\Library\ExactTarget\StructType\AdditionalOperands $additionalOperands
     * @return \App\Library\ExactTarget\StructType\ComplexFilterPart
     */
    public function setAdditionalOperands(\App\Library\ExactTarget\StructType\AdditionalOperands $additionalOperands = null)
    {
        $this->AdditionalOperands = $additionalOperands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ComplexFilterPart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
