<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientID StructType
 * @subpackage Structs
 */
class ClientID extends AbstractStructBase
{
    /**
     * The ClientID
     * Meta informations extracted from the WSDL
     * - documentation: Deprecated. Use ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ClientID;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The PartnerClientKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerClientKey;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UserID;
    /**
     * The PartnerUserKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerUserKey;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CreatedBy;
    /**
     * The ModifiedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ModifiedBy;
    /**
     * The EnterpriseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $EnterpriseID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerID;
    /**
     * Constructor method for ClientID
     * @uses ClientID::setClientID()
     * @uses ClientID::setID()
     * @uses ClientID::setPartnerClientKey()
     * @uses ClientID::setUserID()
     * @uses ClientID::setPartnerUserKey()
     * @uses ClientID::setCreatedBy()
     * @uses ClientID::setModifiedBy()
     * @uses ClientID::setEnterpriseID()
     * @uses ClientID::setCustomerKey()
     * @uses ClientID::setCustomerID()
     * @param int $clientID
     * @param int $iD
     * @param string $partnerClientKey
     * @param int $userID
     * @param string $partnerUserKey
     * @param int $createdBy
     * @param int $modifiedBy
     * @param int $enterpriseID
     * @param string $customerKey
     * @param string $customerID
     */
    public function __construct($clientID = null, $iD = null, $partnerClientKey = null, $userID = null, $partnerUserKey = null, $createdBy = null, $modifiedBy = null, $enterpriseID = null, $customerKey = null, $customerID = null)
    {
        $this
            ->setClientID($clientID)
            ->setID($iD)
            ->setPartnerClientKey($partnerClientKey)
            ->setUserID($userID)
            ->setPartnerUserKey($partnerUserKey)
            ->setCreatedBy($createdBy)
            ->setModifiedBy($modifiedBy)
            ->setEnterpriseID($enterpriseID)
            ->setCustomerKey($customerKey)
            ->setCustomerID($customerID);
    }
    /**
     * Get ClientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->ClientID;
    }
    /**
     * Set ClientID value
     * @param int $clientID
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !is_numeric($clientID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($clientID)), __LINE__);
        }
        $this->ClientID = $clientID;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get PartnerClientKey value
     * @return string|null
     */
    public function getPartnerClientKey()
    {
        return $this->PartnerClientKey;
    }
    /**
     * Set PartnerClientKey value
     * @param string $partnerClientKey
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setPartnerClientKey($partnerClientKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerClientKey) && !is_string($partnerClientKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerClientKey)), __LINE__);
        }
        $this->PartnerClientKey = $partnerClientKey;
        return $this;
    }
    /**
     * Get UserID value
     * @return int|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get PartnerUserKey value
     * @return string|null
     */
    public function getPartnerUserKey()
    {
        return $this->PartnerUserKey;
    }
    /**
     * Set PartnerUserKey value
     * @param string $partnerUserKey
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setPartnerUserKey($partnerUserKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerUserKey) && !is_string($partnerUserKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerUserKey)), __LINE__);
        }
        $this->PartnerUserKey = $partnerUserKey;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return int|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param int $createdBy
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: int
        if (!is_null($createdBy) && !is_numeric($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return int|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param int $modifiedBy
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setModifiedBy($modifiedBy = null)
    {
        // validation for constraint: int
        if (!is_null($modifiedBy) && !is_numeric($modifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($modifiedBy)), __LINE__);
        }
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Get EnterpriseID value
     * @return int|null
     */
    public function getEnterpriseID()
    {
        return $this->EnterpriseID;
    }
    /**
     * Set EnterpriseID value
     * @param int $enterpriseID
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setEnterpriseID($enterpriseID = null)
    {
        // validation for constraint: int
        if (!is_null($enterpriseID) && !is_numeric($enterpriseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($enterpriseID)), __LINE__);
        }
        $this->EnterpriseID = $enterpriseID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ClientID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
