<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClickEvent StructType
 * @subpackage Structs
 */
class ClickEvent extends TrackingEvent
{
    /**
     * The URLID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $URLID;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The URLIDLong
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $URLIDLong;
    /**
     * Constructor method for ClickEvent
     * @uses ClickEvent::setURLID()
     * @uses ClickEvent::setURL()
     * @uses ClickEvent::setURLIDLong()
     * @param int $uRLID
     * @param string $uRL
     * @param int $uRLIDLong
     */
    public function __construct($uRLID = null, $uRL = null, $uRLIDLong = null)
    {
        $this
            ->setURLID($uRLID)
            ->setURL($uRL)
            ->setURLIDLong($uRLIDLong);
    }
    /**
     * Get URLID value
     * @return int|null
     */
    public function getURLID()
    {
        return $this->URLID;
    }
    /**
     * Set URLID value
     * @param int $uRLID
     * @return \App\Library\ExactTarget\StructType\ClickEvent
     */
    public function setURLID($uRLID = null)
    {
        // validation for constraint: int
        if (!is_null($uRLID) && !is_numeric($uRLID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uRLID)), __LINE__);
        }
        $this->URLID = $uRLID;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \App\Library\ExactTarget\StructType\ClickEvent
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get URLIDLong value
     * @return int|null
     */
    public function getURLIDLong()
    {
        return $this->URLIDLong;
    }
    /**
     * Set URLIDLong value
     * @param int $uRLIDLong
     * @return \App\Library\ExactTarget\StructType\ClickEvent
     */
    public function setURLIDLong($uRLIDLong = null)
    {
        // validation for constraint: int
        if (!is_null($uRLIDLong) && !is_numeric($uRLIDLong)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uRLIDLong)), __LINE__);
        }
        $this->URLIDLong = $uRLIDLong;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ClickEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
