<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignPerformOptions StructType
 * @subpackage Structs
 */
class CampaignPerformOptions extends PerformOptions
{
    /**
     * The OccurrenceIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OccurrenceIDs;
    /**
     * The OccurrenceIDsIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OccurrenceIDsIndex;
    /**
     * Constructor method for CampaignPerformOptions
     * @uses CampaignPerformOptions::setOccurrenceIDs()
     * @uses CampaignPerformOptions::setOccurrenceIDsIndex()
     * @param string[] $occurrenceIDs
     * @param int $occurrenceIDsIndex
     */
    public function __construct(array $occurrenceIDs = array(), $occurrenceIDsIndex = null)
    {
        $this
            ->setOccurrenceIDs($occurrenceIDs)
            ->setOccurrenceIDsIndex($occurrenceIDsIndex);
    }
    /**
     * Get OccurrenceIDs value
     * @return string[]|null
     */
    public function getOccurrenceIDs()
    {
        return $this->OccurrenceIDs;
    }
    /**
     * Set OccurrenceIDs value
     * @throws \InvalidArgumentException
     * @param string[] $occurrenceIDs
     * @return \App\Library\ExactTarget\StructType\CampaignPerformOptions
     */
    public function setOccurrenceIDs(array $occurrenceIDs = array())
    {
        foreach ($occurrenceIDs as $campaignPerformOptionsOccurrenceIDsItem) {
            // validation for constraint: itemType
            if (!is_string($campaignPerformOptionsOccurrenceIDsItem)) {
                throw new \InvalidArgumentException(sprintf('The OccurrenceIDs property can only contain items of string, "%s" given', is_object($campaignPerformOptionsOccurrenceIDsItem) ? get_class($campaignPerformOptionsOccurrenceIDsItem) : gettype($campaignPerformOptionsOccurrenceIDsItem)), __LINE__);
            }
        }
        $this->OccurrenceIDs = $occurrenceIDs;
        return $this;
    }
    /**
     * Add item to OccurrenceIDs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Library\ExactTarget\StructType\CampaignPerformOptions
     */
    public function addToOccurrenceIDs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OccurrenceIDs property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OccurrenceIDs[] = $item;
        return $this;
    }
    /**
     * Get OccurrenceIDsIndex value
     * @return int|null
     */
    public function getOccurrenceIDsIndex()
    {
        return $this->OccurrenceIDsIndex;
    }
    /**
     * Set OccurrenceIDsIndex value
     * @param int $occurrenceIDsIndex
     * @return \App\Library\ExactTarget\StructType\CampaignPerformOptions
     */
    public function setOccurrenceIDsIndex($occurrenceIDsIndex = null)
    {
        // validation for constraint: int
        if (!is_null($occurrenceIDsIndex) && !is_numeric($occurrenceIDsIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($occurrenceIDsIndex)), __LINE__);
        }
        $this->OccurrenceIDsIndex = $occurrenceIDsIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\CampaignPerformOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
