<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessUnit StructType
 * @subpackage Structs
 */
class BusinessUnit extends Account
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DefaultSendClassification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SendClassification
     */
    public $DefaultSendClassification;
    /**
     * The DefaultHomePage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\LandingPage
     */
    public $DefaultHomePage;
    /**
     * The SubscriberFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FilterPart
     */
    public $SubscriberFilter;
    /**
     * The MasterUnsubscribeBehavior
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MasterUnsubscribeBehavior;
    /**
     * Constructor method for BusinessUnit
     * @uses BusinessUnit::setDescription()
     * @uses BusinessUnit::setDefaultSendClassification()
     * @uses BusinessUnit::setDefaultHomePage()
     * @uses BusinessUnit::setSubscriberFilter()
     * @uses BusinessUnit::setMasterUnsubscribeBehavior()
     * @param string $description
     * @param \App\Library\ExactTarget\StructType\SendClassification $defaultSendClassification
     * @param \App\Library\ExactTarget\StructType\LandingPage $defaultHomePage
     * @param \App\Library\ExactTarget\StructType\FilterPart $subscriberFilter
     * @param string $masterUnsubscribeBehavior
     */
    public function __construct($description = null, \App\Library\ExactTarget\StructType\SendClassification $defaultSendClassification = null, \App\Library\ExactTarget\StructType\LandingPage $defaultHomePage = null, \App\Library\ExactTarget\StructType\FilterPart $subscriberFilter = null, $masterUnsubscribeBehavior = null)
    {
        $this
            ->setDescription($description)
            ->setDefaultSendClassification($defaultSendClassification)
            ->setDefaultHomePage($defaultHomePage)
            ->setSubscriberFilter($subscriberFilter)
            ->setMasterUnsubscribeBehavior($masterUnsubscribeBehavior);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\BusinessUnit
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DefaultSendClassification value
     * @return \App\Library\ExactTarget\StructType\SendClassification|null
     */
    public function getDefaultSendClassification()
    {
        return $this->DefaultSendClassification;
    }
    /**
     * Set DefaultSendClassification value
     * @param \App\Library\ExactTarget\StructType\SendClassification $defaultSendClassification
     * @return \App\Library\ExactTarget\StructType\BusinessUnit
     */
    public function setDefaultSendClassification(\App\Library\ExactTarget\StructType\SendClassification $defaultSendClassification = null)
    {
        $this->DefaultSendClassification = $defaultSendClassification;
        return $this;
    }
    /**
     * Get DefaultHomePage value
     * @return \App\Library\ExactTarget\StructType\LandingPage|null
     */
    public function getDefaultHomePage()
    {
        return $this->DefaultHomePage;
    }
    /**
     * Set DefaultHomePage value
     * @param \App\Library\ExactTarget\StructType\LandingPage $defaultHomePage
     * @return \App\Library\ExactTarget\StructType\BusinessUnit
     */
    public function setDefaultHomePage(\App\Library\ExactTarget\StructType\LandingPage $defaultHomePage = null)
    {
        $this->DefaultHomePage = $defaultHomePage;
        return $this;
    }
    /**
     * Get SubscriberFilter value
     * @return \App\Library\ExactTarget\StructType\FilterPart|null
     */
    public function getSubscriberFilter()
    {
        return $this->SubscriberFilter;
    }
    /**
     * Set SubscriberFilter value
     * @param \App\Library\ExactTarget\StructType\FilterPart $subscriberFilter
     * @return \App\Library\ExactTarget\StructType\BusinessUnit
     */
    public function setSubscriberFilter(\App\Library\ExactTarget\StructType\FilterPart $subscriberFilter = null)
    {
        $this->SubscriberFilter = $subscriberFilter;
        return $this;
    }
    /**
     * Get MasterUnsubscribeBehavior value
     * @return string|null
     */
    public function getMasterUnsubscribeBehavior()
    {
        return $this->MasterUnsubscribeBehavior;
    }
    /**
     * Set MasterUnsubscribeBehavior value
     * @uses \App\Library\ExactTarget\EnumType\UnsubscribeBehaviorEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\UnsubscribeBehaviorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $masterUnsubscribeBehavior
     * @return \App\Library\ExactTarget\StructType\BusinessUnit
     */
    public function setMasterUnsubscribeBehavior($masterUnsubscribeBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\UnsubscribeBehaviorEnum::valueIsValid($masterUnsubscribeBehavior)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $masterUnsubscribeBehavior, implode(', ', \App\Library\ExactTarget\EnumType\UnsubscribeBehaviorEnum::getValidValues())), __LINE__);
        }
        $this->MasterUnsubscribeBehavior = $masterUnsubscribeBehavior;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\BusinessUnit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
