<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Brand StructType
 * @subpackage Structs
 */
class Brand extends APIObject
{
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $BrandID;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Label;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The BrandTags
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Library\ExactTarget\StructType\BrandTag[]
     */
    public $BrandTags;
    /**
     * Constructor method for Brand
     * @uses Brand::setBrandID()
     * @uses Brand::setLabel()
     * @uses Brand::setComment()
     * @uses Brand::setBrandTags()
     * @param int $brandID
     * @param string $label
     * @param string $comment
     * @param \App\Library\ExactTarget\StructType\BrandTag[] $brandTags
     */
    public function __construct($brandID = null, $label = null, $comment = null, array $brandTags = array())
    {
        $this
            ->setBrandID($brandID)
            ->setLabel($label)
            ->setComment($comment)
            ->setBrandTags($brandTags);
    }
    /**
     * Get BrandID value
     * @return int|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param int $brandID
     * @return \App\Library\ExactTarget\StructType\Brand
     */
    public function setBrandID($brandID = null)
    {
        // validation for constraint: int
        if (!is_null($brandID) && !is_numeric($brandID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($brandID)), __LINE__);
        }
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get Label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param string $label
     * @return \App\Library\ExactTarget\StructType\Brand
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \App\Library\ExactTarget\StructType\Brand
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get BrandTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Library\ExactTarget\StructType\BrandTag[]|null
     */
    public function getBrandTags()
    {
        return isset($this->BrandTags) ? $this->BrandTags : null;
    }
    /**
     * Set BrandTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\BrandTag[] $brandTags
     * @return \App\Library\ExactTarget\StructType\Brand
     */
    public function setBrandTags(array $brandTags = array())
    {
        foreach ($brandTags as $brandBrandTagsItem) {
            // validation for constraint: itemType
            if (!$brandBrandTagsItem instanceof \App\Library\ExactTarget\StructType\BrandTag) {
                throw new \InvalidArgumentException(sprintf('The BrandTags property can only contain items of \App\Library\ExactTarget\StructType\BrandTag, "%s" given', is_object($brandBrandTagsItem) ? get_class($brandBrandTagsItem) : gettype($brandBrandTagsItem)), __LINE__);
            }
        }
        if (is_null($brandTags) || (is_array($brandTags) && empty($brandTags))) {
            unset($this->BrandTags);
        } else {
            $this->BrandTags = $brandTags;
        }
        return $this;
    }
    /**
     * Add item to BrandTags value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\BrandTag $item
     * @return \App\Library\ExactTarget\StructType\Brand
     */
    public function addToBrandTags(\App\Library\ExactTarget\StructType\BrandTag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\BrandTag) {
            throw new \InvalidArgumentException(sprintf('The BrandTags property can only contain items of \App\Library\ExactTarget\StructType\BrandTag, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BrandTags[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Brand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
