<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BounceEvent StructType
 * @subpackage Structs
 */
class BounceEvent extends TrackingEvent
{
    /**
     * The SMTPCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SMTPCode;
    /**
     * The BounceCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BounceCategory;
    /**
     * The SMTPReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SMTPReason;
    /**
     * The BounceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BounceType;
    /**
     * Constructor method for BounceEvent
     * @uses BounceEvent::setSMTPCode()
     * @uses BounceEvent::setBounceCategory()
     * @uses BounceEvent::setSMTPReason()
     * @uses BounceEvent::setBounceType()
     * @param string $sMTPCode
     * @param string $bounceCategory
     * @param string $sMTPReason
     * @param string $bounceType
     */
    public function __construct($sMTPCode = null, $bounceCategory = null, $sMTPReason = null, $bounceType = null)
    {
        $this
            ->setSMTPCode($sMTPCode)
            ->setBounceCategory($bounceCategory)
            ->setSMTPReason($sMTPReason)
            ->setBounceType($bounceType);
    }
    /**
     * Get SMTPCode value
     * @return string|null
     */
    public function getSMTPCode()
    {
        return $this->SMTPCode;
    }
    /**
     * Set SMTPCode value
     * @param string $sMTPCode
     * @return \App\Library\ExactTarget\StructType\BounceEvent
     */
    public function setSMTPCode($sMTPCode = null)
    {
        // validation for constraint: string
        if (!is_null($sMTPCode) && !is_string($sMTPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sMTPCode)), __LINE__);
        }
        $this->SMTPCode = $sMTPCode;
        return $this;
    }
    /**
     * Get BounceCategory value
     * @return string|null
     */
    public function getBounceCategory()
    {
        return $this->BounceCategory;
    }
    /**
     * Set BounceCategory value
     * @param string $bounceCategory
     * @return \App\Library\ExactTarget\StructType\BounceEvent
     */
    public function setBounceCategory($bounceCategory = null)
    {
        // validation for constraint: string
        if (!is_null($bounceCategory) && !is_string($bounceCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bounceCategory)), __LINE__);
        }
        $this->BounceCategory = $bounceCategory;
        return $this;
    }
    /**
     * Get SMTPReason value
     * @return string|null
     */
    public function getSMTPReason()
    {
        return $this->SMTPReason;
    }
    /**
     * Set SMTPReason value
     * @param string $sMTPReason
     * @return \App\Library\ExactTarget\StructType\BounceEvent
     */
    public function setSMTPReason($sMTPReason = null)
    {
        // validation for constraint: string
        if (!is_null($sMTPReason) && !is_string($sMTPReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sMTPReason)), __LINE__);
        }
        $this->SMTPReason = $sMTPReason;
        return $this;
    }
    /**
     * Get BounceType value
     * @return string|null
     */
    public function getBounceType()
    {
        return $this->BounceType;
    }
    /**
     * Set BounceType value
     * @param string $bounceType
     * @return \App\Library\ExactTarget\StructType\BounceEvent
     */
    public function setBounceType($bounceType = null)
    {
        // validation for constraint: string
        if (!is_null($bounceType) && !is_string($bounceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bounceType)), __LINE__);
        }
        $this->BounceType = $bounceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\BounceEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
