<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationTasks StructType
 * @subpackage Structs
 */
class AutomationTasks extends AbstractStructBase
{
    /**
     * The AutomationTask
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationTask[]
     */
    public $AutomationTask;
    /**
     * Constructor method for AutomationTasks
     * @uses AutomationTasks::setAutomationTask()
     * @param \App\Library\ExactTarget\StructType\AutomationTask[] $automationTask
     */
    public function __construct(array $automationTask = array())
    {
        $this
            ->setAutomationTask($automationTask);
    }
    /**
     * Get AutomationTask value
     * @return \App\Library\ExactTarget\StructType\AutomationTask[]|null
     */
    public function getAutomationTask()
    {
        return $this->AutomationTask;
    }
    /**
     * Set AutomationTask value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationTask[] $automationTask
     * @return \App\Library\ExactTarget\StructType\AutomationTasks
     */
    public function setAutomationTask(array $automationTask = array())
    {
        foreach ($automationTask as $automationTasksAutomationTaskItem) {
            // validation for constraint: itemType
            if (!$automationTasksAutomationTaskItem instanceof \App\Library\ExactTarget\StructType\AutomationTask) {
                throw new \InvalidArgumentException(sprintf('The AutomationTask property can only contain items of \App\Library\ExactTarget\StructType\AutomationTask, "%s" given', is_object($automationTasksAutomationTaskItem) ? get_class($automationTasksAutomationTaskItem) : gettype($automationTasksAutomationTaskItem)), __LINE__);
            }
        }
        $this->AutomationTask = $automationTask;
        return $this;
    }
    /**
     * Add item to AutomationTask value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationTask $item
     * @return \App\Library\ExactTarget\StructType\AutomationTasks
     */
    public function addToAutomationTask(\App\Library\ExactTarget\StructType\AutomationTask $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AutomationTask) {
            throw new \InvalidArgumentException(sprintf('The AutomationTask property can only contain items of \App\Library\ExactTarget\StructType\AutomationTask, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AutomationTask[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationTasks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
