<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationSource StructType
 * @subpackage Structs
 */
class AutomationSource extends AbstractStructBase
{
    /**
     * The AutomationSourceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutomationSourceID;
    /**
     * The AutomationSourceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutomationSourceType;
    /**
     * Constructor method for AutomationSource
     * @uses AutomationSource::setAutomationSourceID()
     * @uses AutomationSource::setAutomationSourceType()
     * @param string $automationSourceID
     * @param string $automationSourceType
     */
    public function __construct($automationSourceID = null, $automationSourceType = null)
    {
        $this
            ->setAutomationSourceID($automationSourceID)
            ->setAutomationSourceType($automationSourceType);
    }
    /**
     * Get AutomationSourceID value
     * @return string|null
     */
    public function getAutomationSourceID()
    {
        return $this->AutomationSourceID;
    }
    /**
     * Set AutomationSourceID value
     * @param string $automationSourceID
     * @return \App\Library\ExactTarget\StructType\AutomationSource
     */
    public function setAutomationSourceID($automationSourceID = null)
    {
        // validation for constraint: string
        if (!is_null($automationSourceID) && !is_string($automationSourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automationSourceID)), __LINE__);
        }
        $this->AutomationSourceID = $automationSourceID;
        return $this;
    }
    /**
     * Get AutomationSourceType value
     * @return string|null
     */
    public function getAutomationSourceType()
    {
        return $this->AutomationSourceType;
    }
    /**
     * Set AutomationSourceType value
     * @param string $automationSourceType
     * @return \App\Library\ExactTarget\StructType\AutomationSource
     */
    public function setAutomationSourceType($automationSourceType = null)
    {
        // validation for constraint: string
        if (!is_null($automationSourceType) && !is_string($automationSourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automationSourceType)), __LINE__);
        }
        $this->AutomationSourceType = $automationSourceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationSource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
