<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationInstances StructType
 * @subpackage Structs
 */
class AutomationInstances extends APIObject
{
    /**
     * The InstanceCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $InstanceCount;
    /**
     * The AutomationInstanceCollection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationInstanceCollection
     */
    public $AutomationInstanceCollection;
    /**
     * Constructor method for AutomationInstances
     * @uses AutomationInstances::setInstanceCount()
     * @uses AutomationInstances::setAutomationInstanceCollection()
     * @param int $instanceCount
     * @param \App\Library\ExactTarget\StructType\AutomationInstanceCollection $automationInstanceCollection
     */
    public function __construct($instanceCount = null, \App\Library\ExactTarget\StructType\AutomationInstanceCollection $automationInstanceCollection = null)
    {
        $this
            ->setInstanceCount($instanceCount)
            ->setAutomationInstanceCollection($automationInstanceCollection);
    }
    /**
     * Get InstanceCount value
     * @return int|null
     */
    public function getInstanceCount()
    {
        return $this->InstanceCount;
    }
    /**
     * Set InstanceCount value
     * @param int $instanceCount
     * @return \App\Library\ExactTarget\StructType\AutomationInstances
     */
    public function setInstanceCount($instanceCount = null)
    {
        // validation for constraint: int
        if (!is_null($instanceCount) && !is_numeric($instanceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($instanceCount)), __LINE__);
        }
        $this->InstanceCount = $instanceCount;
        return $this;
    }
    /**
     * Get AutomationInstanceCollection value
     * @return \App\Library\ExactTarget\StructType\AutomationInstanceCollection|null
     */
    public function getAutomationInstanceCollection()
    {
        return $this->AutomationInstanceCollection;
    }
    /**
     * Set AutomationInstanceCollection value
     * @param \App\Library\ExactTarget\StructType\AutomationInstanceCollection $automationInstanceCollection
     * @return \App\Library\ExactTarget\StructType\AutomationInstances
     */
    public function setAutomationInstanceCollection(\App\Library\ExactTarget\StructType\AutomationInstanceCollection $automationInstanceCollection = null)
    {
        $this->AutomationInstanceCollection = $automationInstanceCollection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationInstances
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
