<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationInstanceCollection StructType
 * @subpackage Structs
 */
class AutomationInstanceCollection extends AbstractStructBase
{
    /**
     * The AutomationInstance
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationInstance[]
     */
    public $AutomationInstance;
    /**
     * Constructor method for AutomationInstanceCollection
     * @uses AutomationInstanceCollection::setAutomationInstance()
     * @param \App\Library\ExactTarget\StructType\AutomationInstance[] $automationInstance
     */
    public function __construct(array $automationInstance = array())
    {
        $this
            ->setAutomationInstance($automationInstance);
    }
    /**
     * Get AutomationInstance value
     * @return \App\Library\ExactTarget\StructType\AutomationInstance[]|null
     */
    public function getAutomationInstance()
    {
        return $this->AutomationInstance;
    }
    /**
     * Set AutomationInstance value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationInstance[] $automationInstance
     * @return \App\Library\ExactTarget\StructType\AutomationInstanceCollection
     */
    public function setAutomationInstance(array $automationInstance = array())
    {
        foreach ($automationInstance as $automationInstanceCollectionAutomationInstanceItem) {
            // validation for constraint: itemType
            if (!$automationInstanceCollectionAutomationInstanceItem instanceof \App\Library\ExactTarget\StructType\AutomationInstance) {
                throw new \InvalidArgumentException(sprintf('The AutomationInstance property can only contain items of \App\Library\ExactTarget\StructType\AutomationInstance, "%s" given', is_object($automationInstanceCollectionAutomationInstanceItem) ? get_class($automationInstanceCollectionAutomationInstanceItem) : gettype($automationInstanceCollectionAutomationInstanceItem)), __LINE__);
            }
        }
        $this->AutomationInstance = $automationInstance;
        return $this;
    }
    /**
     * Add item to AutomationInstance value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AutomationInstance $item
     * @return \App\Library\ExactTarget\StructType\AutomationInstanceCollection
     */
    public function addToAutomationInstance(\App\Library\ExactTarget\StructType\AutomationInstance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AutomationInstance) {
            throw new \InvalidArgumentException(sprintf('The AutomationInstance property can only contain items of \App\Library\ExactTarget\StructType\AutomationInstance, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AutomationInstance[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationInstanceCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
