<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutomationActivity StructType
 * @subpackage Structs
 */
class AutomationActivity extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The Definition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $Definition;
    /**
     * The Automation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Automation
     */
    public $Automation;
    /**
     * The AutomationTask
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationTask
     */
    public $AutomationTask;
    /**
     * The Sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Sequence;
    /**
     * The ActivityObject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $ActivityObject;
    /**
     * The SerializedObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerializedObject;
    /**
     * Constructor method for AutomationActivity
     * @uses AutomationActivity::setName()
     * @uses AutomationActivity::setDescription()
     * @uses AutomationActivity::setIsActive()
     * @uses AutomationActivity::setDefinition()
     * @uses AutomationActivity::setAutomation()
     * @uses AutomationActivity::setAutomationTask()
     * @uses AutomationActivity::setSequence()
     * @uses AutomationActivity::setActivityObject()
     * @uses AutomationActivity::setSerializedObject()
     * @param string $name
     * @param string $description
     * @param bool $isActive
     * @param \App\Library\ExactTarget\StructType\APIObject $definition
     * @param \App\Library\ExactTarget\StructType\Automation $automation
     * @param \App\Library\ExactTarget\StructType\AutomationTask $automationTask
     * @param int $sequence
     * @param \App\Library\ExactTarget\StructType\APIObject $activityObject
     * @param string $serializedObject
     */
    public function __construct($name = null, $description = null, $isActive = null, \App\Library\ExactTarget\StructType\APIObject $definition = null, \App\Library\ExactTarget\StructType\Automation $automation = null, \App\Library\ExactTarget\StructType\AutomationTask $automationTask = null, $sequence = null, \App\Library\ExactTarget\StructType\APIObject $activityObject = null, $serializedObject = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setDefinition($definition)
            ->setAutomation($automation)
            ->setAutomationTask($automationTask)
            ->setSequence($sequence)
            ->setActivityObject($activityObject)
            ->setSerializedObject($serializedObject);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Definition value
     * @return \App\Library\ExactTarget\StructType\APIObject|null
     */
    public function getDefinition()
    {
        return $this->Definition;
    }
    /**
     * Set Definition value
     * @param \App\Library\ExactTarget\StructType\APIObject $definition
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public function setDefinition(\App\Library\ExactTarget\StructType\APIObject $definition = null)
    {
        $this->Definition = $definition;
        return $this;
    }
    /**
     * Get Automation value
     * @return \App\Library\ExactTarget\StructType\Automation|null
     */
    public function getAutomation()
    {
        return $this->Automation;
    }
    /**
     * Set Automation value
     * @param \App\Library\ExactTarget\StructType\Automation $automation
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public function setAutomation(\App\Library\ExactTarget\StructType\Automation $automation = null)
    {
        $this->Automation = $automation;
        return $this;
    }
    /**
     * Get AutomationTask value
     * @return \App\Library\ExactTarget\StructType\AutomationTask|null
     */
    public function getAutomationTask()
    {
        return $this->AutomationTask;
    }
    /**
     * Set AutomationTask value
     * @param \App\Library\ExactTarget\StructType\AutomationTask $automationTask
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public function setAutomationTask(\App\Library\ExactTarget\StructType\AutomationTask $automationTask = null)
    {
        $this->AutomationTask = $automationTask;
        return $this;
    }
    /**
     * Get Sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->Sequence;
    }
    /**
     * Set Sequence value
     * @param int $sequence
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->Sequence = $sequence;
        return $this;
    }
    /**
     * Get ActivityObject value
     * @return \App\Library\ExactTarget\StructType\APIObject|null
     */
    public function getActivityObject()
    {
        return $this->ActivityObject;
    }
    /**
     * Set ActivityObject value
     * @param \App\Library\ExactTarget\StructType\APIObject $activityObject
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public function setActivityObject(\App\Library\ExactTarget\StructType\APIObject $activityObject = null)
    {
        $this->ActivityObject = $activityObject;
        return $this;
    }
    /**
     * Get SerializedObject value
     * @return string|null
     */
    public function getSerializedObject()
    {
        return $this->SerializedObject;
    }
    /**
     * Set SerializedObject value
     * @param string $serializedObject
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public function setSerializedObject($serializedObject = null)
    {
        // validation for constraint: string
        if (!is_null($serializedObject) && !is_string($serializedObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serializedObject)), __LINE__);
        }
        $this->SerializedObject = $serializedObject;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AutomationActivity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
