<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Automation StructType
 * @subpackage Structs
 */
class Automation extends InteractionDefinition
{
    /**
     * The Schedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public $Schedule;
    /**
     * The AutomationTasks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationTasks
     */
    public $AutomationTasks;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The AutomationSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AutomationSource
     */
    public $AutomationSource;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Status;
    /**
     * The Notifications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Notifications
     */
    public $Notifications;
    /**
     * The ScheduledTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledTime;
    /**
     * The AutomationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AutomationType;
    /**
     * The UpdateModified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UpdateModified;
    /**
     * The LastRunInstanceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastRunInstanceID;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CreatedBy;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryID;
    /**
     * The LastRunTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastRunTime;
    /**
     * The LastSaveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastSaveDate;
    /**
     * The ModifiedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ModifiedBy;
    /**
     * The RecurrenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecurrenceID;
    /**
     * The LastSavedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $LastSavedBy;
    /**
     * Constructor method for Automation
     * @uses Automation::setSchedule()
     * @uses Automation::setAutomationTasks()
     * @uses Automation::setIsActive()
     * @uses Automation::setAutomationSource()
     * @uses Automation::setStatus()
     * @uses Automation::setNotifications()
     * @uses Automation::setScheduledTime()
     * @uses Automation::setAutomationType()
     * @uses Automation::setUpdateModified()
     * @uses Automation::setLastRunInstanceID()
     * @uses Automation::setCreatedBy()
     * @uses Automation::setCategoryID()
     * @uses Automation::setLastRunTime()
     * @uses Automation::setLastSaveDate()
     * @uses Automation::setModifiedBy()
     * @uses Automation::setRecurrenceID()
     * @uses Automation::setLastSavedBy()
     * @param \App\Library\ExactTarget\StructType\ScheduleDefinition $schedule
     * @param \App\Library\ExactTarget\StructType\AutomationTasks $automationTasks
     * @param bool $isActive
     * @param \App\Library\ExactTarget\StructType\AutomationSource $automationSource
     * @param int $status
     * @param \App\Library\ExactTarget\StructType\Notifications $notifications
     * @param string $scheduledTime
     * @param string $automationType
     * @param bool $updateModified
     * @param string $lastRunInstanceID
     * @param int $createdBy
     * @param string $categoryID
     * @param string $lastRunTime
     * @param string $lastSaveDate
     * @param int $modifiedBy
     * @param string $recurrenceID
     * @param int $lastSavedBy
     */
    public function __construct(\App\Library\ExactTarget\StructType\ScheduleDefinition $schedule = null, \App\Library\ExactTarget\StructType\AutomationTasks $automationTasks = null, $isActive = null, \App\Library\ExactTarget\StructType\AutomationSource $automationSource = null, $status = null, \App\Library\ExactTarget\StructType\Notifications $notifications = null, $scheduledTime = null, $automationType = null, $updateModified = null, $lastRunInstanceID = null, $createdBy = null, $categoryID = null, $lastRunTime = null, $lastSaveDate = null, $modifiedBy = null, $recurrenceID = null, $lastSavedBy = null)
    {
        $this
            ->setSchedule($schedule)
            ->setAutomationTasks($automationTasks)
            ->setIsActive($isActive)
            ->setAutomationSource($automationSource)
            ->setStatus($status)
            ->setNotifications($notifications)
            ->setScheduledTime($scheduledTime)
            ->setAutomationType($automationType)
            ->setUpdateModified($updateModified)
            ->setLastRunInstanceID($lastRunInstanceID)
            ->setCreatedBy($createdBy)
            ->setCategoryID($categoryID)
            ->setLastRunTime($lastRunTime)
            ->setLastSaveDate($lastSaveDate)
            ->setModifiedBy($modifiedBy)
            ->setRecurrenceID($recurrenceID)
            ->setLastSavedBy($lastSavedBy);
    }
    /**
     * Get Schedule value
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition|null
     */
    public function getSchedule()
    {
        return $this->Schedule;
    }
    /**
     * Set Schedule value
     * @param \App\Library\ExactTarget\StructType\ScheduleDefinition $schedule
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setSchedule(\App\Library\ExactTarget\StructType\ScheduleDefinition $schedule = null)
    {
        $this->Schedule = $schedule;
        return $this;
    }
    /**
     * Get AutomationTasks value
     * @return \App\Library\ExactTarget\StructType\AutomationTasks|null
     */
    public function getAutomationTasks()
    {
        return $this->AutomationTasks;
    }
    /**
     * Set AutomationTasks value
     * @param \App\Library\ExactTarget\StructType\AutomationTasks $automationTasks
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setAutomationTasks(\App\Library\ExactTarget\StructType\AutomationTasks $automationTasks = null)
    {
        $this->AutomationTasks = $automationTasks;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get AutomationSource value
     * @return \App\Library\ExactTarget\StructType\AutomationSource|null
     */
    public function getAutomationSource()
    {
        return $this->AutomationSource;
    }
    /**
     * Set AutomationSource value
     * @param \App\Library\ExactTarget\StructType\AutomationSource $automationSource
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setAutomationSource(\App\Library\ExactTarget\StructType\AutomationSource $automationSource = null)
    {
        $this->AutomationSource = $automationSource;
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \App\Library\ExactTarget\StructType\Notifications|null
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * Set Notifications value
     * @param \App\Library\ExactTarget\StructType\Notifications $notifications
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setNotifications(\App\Library\ExactTarget\StructType\Notifications $notifications = null)
    {
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Get ScheduledTime value
     * @return string|null
     */
    public function getScheduledTime()
    {
        return $this->ScheduledTime;
    }
    /**
     * Set ScheduledTime value
     * @param string $scheduledTime
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setScheduledTime($scheduledTime = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledTime) && !is_string($scheduledTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledTime)), __LINE__);
        }
        $this->ScheduledTime = $scheduledTime;
        return $this;
    }
    /**
     * Get AutomationType value
     * @return string|null
     */
    public function getAutomationType()
    {
        return $this->AutomationType;
    }
    /**
     * Set AutomationType value
     * @param string $automationType
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setAutomationType($automationType = null)
    {
        // validation for constraint: string
        if (!is_null($automationType) && !is_string($automationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automationType)), __LINE__);
        }
        $this->AutomationType = $automationType;
        return $this;
    }
    /**
     * Get UpdateModified value
     * @return bool|null
     */
    public function getUpdateModified()
    {
        return $this->UpdateModified;
    }
    /**
     * Set UpdateModified value
     * @param bool $updateModified
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setUpdateModified($updateModified = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateModified) && !is_bool($updateModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($updateModified)), __LINE__);
        }
        $this->UpdateModified = $updateModified;
        return $this;
    }
    /**
     * Get LastRunInstanceID value
     * @return string|null
     */
    public function getLastRunInstanceID()
    {
        return $this->LastRunInstanceID;
    }
    /**
     * Set LastRunInstanceID value
     * @param string $lastRunInstanceID
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setLastRunInstanceID($lastRunInstanceID = null)
    {
        // validation for constraint: string
        if (!is_null($lastRunInstanceID) && !is_string($lastRunInstanceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastRunInstanceID)), __LINE__);
        }
        $this->LastRunInstanceID = $lastRunInstanceID;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return int|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param int $createdBy
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: int
        if (!is_null($createdBy) && !is_numeric($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return string|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param string $categoryID
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: string
        if (!is_null($categoryID) && !is_string($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get LastRunTime value
     * @return string|null
     */
    public function getLastRunTime()
    {
        return $this->LastRunTime;
    }
    /**
     * Set LastRunTime value
     * @param string $lastRunTime
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setLastRunTime($lastRunTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastRunTime) && !is_string($lastRunTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastRunTime)), __LINE__);
        }
        $this->LastRunTime = $lastRunTime;
        return $this;
    }
    /**
     * Get LastSaveDate value
     * @return string|null
     */
    public function getLastSaveDate()
    {
        return $this->LastSaveDate;
    }
    /**
     * Set LastSaveDate value
     * @param string $lastSaveDate
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setLastSaveDate($lastSaveDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastSaveDate) && !is_string($lastSaveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastSaveDate)), __LINE__);
        }
        $this->LastSaveDate = $lastSaveDate;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return int|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param int $modifiedBy
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setModifiedBy($modifiedBy = null)
    {
        // validation for constraint: int
        if (!is_null($modifiedBy) && !is_numeric($modifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($modifiedBy)), __LINE__);
        }
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Get RecurrenceID value
     * @return string|null
     */
    public function getRecurrenceID()
    {
        return $this->RecurrenceID;
    }
    /**
     * Set RecurrenceID value
     * @param string $recurrenceID
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setRecurrenceID($recurrenceID = null)
    {
        // validation for constraint: string
        if (!is_null($recurrenceID) && !is_string($recurrenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recurrenceID)), __LINE__);
        }
        $this->RecurrenceID = $recurrenceID;
        return $this;
    }
    /**
     * Get LastSavedBy value
     * @return int|null
     */
    public function getLastSavedBy()
    {
        return $this->LastSavedBy;
    }
    /**
     * Set LastSavedBy value
     * @param int $lastSavedBy
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public function setLastSavedBy($lastSavedBy = null)
    {
        // validation for constraint: int
        if (!is_null($lastSavedBy) && !is_numeric($lastSavedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lastSavedBy)), __LINE__);
        }
        $this->LastSavedBy = $lastSavedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Automation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
