<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AudienceItem StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AudienceItem
 * @subpackage Structs
 */
class AudienceItem extends APIObject
{
    /**
     * The List
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\_List
     */
    public $List;
    /**
     * The SendDefinitionListType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendDefinitionListType;
    /**
     * The CustomObjectID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomObjectID;
    /**
     * The DataSourceTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataSourceTypeID;
    /**
     * Constructor method for AudienceItem
     * @uses AudienceItem::setList()
     * @uses AudienceItem::setSendDefinitionListType()
     * @uses AudienceItem::setCustomObjectID()
     * @uses AudienceItem::setDataSourceTypeID()
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @param string $sendDefinitionListType
     * @param string $customObjectID
     * @param string $dataSourceTypeID
     */
    public function __construct(\App\Library\ExactTarget\StructType\_List $list = null, $sendDefinitionListType = null, $customObjectID = null, $dataSourceTypeID = null)
    {
        $this
            ->setList($list)
            ->setSendDefinitionListType($sendDefinitionListType)
            ->setCustomObjectID($customObjectID)
            ->setDataSourceTypeID($dataSourceTypeID);
    }
    /**
     * Get List value
     * @return \App\Library\ExactTarget\StructType\_List|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @return \App\Library\ExactTarget\StructType\AudienceItem
     */
    public function setList(\App\Library\ExactTarget\StructType\_List $list = null)
    {
        $this->List = $list;
        return $this;
    }
    /**
     * Get SendDefinitionListType value
     * @return string|null
     */
    public function getSendDefinitionListType()
    {
        return $this->SendDefinitionListType;
    }
    /**
     * Set SendDefinitionListType value
     * @uses \App\Library\ExactTarget\EnumType\SendDefinitionListTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SendDefinitionListTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendDefinitionListType
     * @return \App\Library\ExactTarget\StructType\AudienceItem
     */
    public function setSendDefinitionListType($sendDefinitionListType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SendDefinitionListTypeEnum::valueIsValid($sendDefinitionListType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sendDefinitionListType, implode(', ', \App\Library\ExactTarget\EnumType\SendDefinitionListTypeEnum::getValidValues())), __LINE__);
        }
        $this->SendDefinitionListType = $sendDefinitionListType;
        return $this;
    }
    /**
     * Get CustomObjectID value
     * @return string|null
     */
    public function getCustomObjectID()
    {
        return $this->CustomObjectID;
    }
    /**
     * Set CustomObjectID value
     * @param string $customObjectID
     * @return \App\Library\ExactTarget\StructType\AudienceItem
     */
    public function setCustomObjectID($customObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($customObjectID) && !is_string($customObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customObjectID)), __LINE__);
        }
        $this->CustomObjectID = $customObjectID;
        return $this;
    }
    /**
     * Get DataSourceTypeID value
     * @return string|null
     */
    public function getDataSourceTypeID()
    {
        return $this->DataSourceTypeID;
    }
    /**
     * Set DataSourceTypeID value
     * @uses \App\Library\ExactTarget\EnumType\DataSourceTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DataSourceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataSourceTypeID
     * @return \App\Library\ExactTarget\StructType\AudienceItem
     */
    public function setDataSourceTypeID($dataSourceTypeID = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DataSourceTypeEnum::valueIsValid($dataSourceTypeID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dataSourceTypeID, implode(', ', \App\Library\ExactTarget\EnumType\DataSourceTypeEnum::getValidValues())), __LINE__);
        }
        $this->DataSourceTypeID = $dataSourceTypeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AudienceItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
