<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeMap StructType
 * @subpackage Structs
 */
class AttributeMap extends APIProperty
{
    /**
     * The EntityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityName;
    /**
     * The ColumnName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ColumnName;
    /**
     * The ColumnNameMappedTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ColumnNameMappedTo;
    /**
     * The EntityNameMappedTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityNameMappedTo;
    /**
     * The AdditionalData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $AdditionalData;
    /**
     * Constructor method for AttributeMap
     * @uses AttributeMap::setEntityName()
     * @uses AttributeMap::setColumnName()
     * @uses AttributeMap::setColumnNameMappedTo()
     * @uses AttributeMap::setEntityNameMappedTo()
     * @uses AttributeMap::setAdditionalData()
     * @param string $entityName
     * @param string $columnName
     * @param string $columnNameMappedTo
     * @param string $entityNameMappedTo
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $additionalData
     */
    public function __construct($entityName = null, $columnName = null, $columnNameMappedTo = null, $entityNameMappedTo = null, array $additionalData = array())
    {
        $this
            ->setEntityName($entityName)
            ->setColumnName($columnName)
            ->setColumnNameMappedTo($columnNameMappedTo)
            ->setEntityNameMappedTo($entityNameMappedTo)
            ->setAdditionalData($additionalData);
    }
    /**
     * Get EntityName value
     * @return string|null
     */
    public function getEntityName()
    {
        return $this->EntityName;
    }
    /**
     * Set EntityName value
     * @param string $entityName
     * @return \App\Library\ExactTarget\StructType\AttributeMap
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityName)), __LINE__);
        }
        $this->EntityName = $entityName;
        return $this;
    }
    /**
     * Get ColumnName value
     * @return string|null
     */
    public function getColumnName()
    {
        return $this->ColumnName;
    }
    /**
     * Set ColumnName value
     * @param string $columnName
     * @return \App\Library\ExactTarget\StructType\AttributeMap
     */
    public function setColumnName($columnName = null)
    {
        // validation for constraint: string
        if (!is_null($columnName) && !is_string($columnName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($columnName)), __LINE__);
        }
        $this->ColumnName = $columnName;
        return $this;
    }
    /**
     * Get ColumnNameMappedTo value
     * @return string|null
     */
    public function getColumnNameMappedTo()
    {
        return $this->ColumnNameMappedTo;
    }
    /**
     * Set ColumnNameMappedTo value
     * @param string $columnNameMappedTo
     * @return \App\Library\ExactTarget\StructType\AttributeMap
     */
    public function setColumnNameMappedTo($columnNameMappedTo = null)
    {
        // validation for constraint: string
        if (!is_null($columnNameMappedTo) && !is_string($columnNameMappedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($columnNameMappedTo)), __LINE__);
        }
        $this->ColumnNameMappedTo = $columnNameMappedTo;
        return $this;
    }
    /**
     * Get EntityNameMappedTo value
     * @return string|null
     */
    public function getEntityNameMappedTo()
    {
        return $this->EntityNameMappedTo;
    }
    /**
     * Set EntityNameMappedTo value
     * @param string $entityNameMappedTo
     * @return \App\Library\ExactTarget\StructType\AttributeMap
     */
    public function setEntityNameMappedTo($entityNameMappedTo = null)
    {
        // validation for constraint: string
        if (!is_null($entityNameMappedTo) && !is_string($entityNameMappedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityNameMappedTo)), __LINE__);
        }
        $this->EntityNameMappedTo = $entityNameMappedTo;
        return $this;
    }
    /**
     * Get AdditionalData value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getAdditionalData()
    {
        return $this->AdditionalData;
    }
    /**
     * Set AdditionalData value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $additionalData
     * @return \App\Library\ExactTarget\StructType\AttributeMap
     */
    public function setAdditionalData(array $additionalData = array())
    {
        foreach ($additionalData as $attributeMapAdditionalDataItem) {
            // validation for constraint: itemType
            if (!$attributeMapAdditionalDataItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The AdditionalData property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($attributeMapAdditionalDataItem) ? get_class($attributeMapAdditionalDataItem) : gettype($attributeMapAdditionalDataItem)), __LINE__);
            }
        }
        $this->AdditionalData = $additionalData;
        return $this;
    }
    /**
     * Add item to AdditionalData value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\AttributeMap
     */
    public function addToAdditionalData(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The AdditionalData property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AttributeMap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
