<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attribute StructType
 * @subpackage Structs
 */
class Attribute extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * The Compression
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\CompressionConfiguration
     */
    public $Compression;
    /**
     * Constructor method for Attribute
     * @uses Attribute::setName()
     * @uses Attribute::setValue()
     * @uses Attribute::setCompression()
     * @param string $name
     * @param string $value
     * @param \App\Library\ExactTarget\StructType\CompressionConfiguration $compression
     */
    public function __construct($name = null, $value = null, \App\Library\ExactTarget\StructType\CompressionConfiguration $compression = null)
    {
        $this
            ->setName($name)
            ->setValue($value)
            ->setCompression($compression);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\Attribute
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \App\Library\ExactTarget\StructType\Attribute
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Compression value
     * @return \App\Library\ExactTarget\StructType\CompressionConfiguration|null
     */
    public function getCompression()
    {
        return $this->Compression;
    }
    /**
     * Set Compression value
     * @param \App\Library\ExactTarget\StructType\CompressionConfiguration $compression
     * @return \App\Library\ExactTarget\StructType\Attribute
     */
    public function setCompression(\App\Library\ExactTarget\StructType\CompressionConfiguration $compression = null)
    {
        $this->Compression = $compression;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Attribute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
