<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociatedBusinessUnits StructType
 * @subpackage Structs
 */
class AssociatedBusinessUnits extends AbstractStructBase
{
    /**
     * The BusinessUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\BusinessUnit[]
     */
    public $BusinessUnit;
    /**
     * Constructor method for AssociatedBusinessUnits
     * @uses AssociatedBusinessUnits::setBusinessUnit()
     * @param \App\Library\ExactTarget\StructType\BusinessUnit[] $businessUnit
     */
    public function __construct(array $businessUnit = array())
    {
        $this
            ->setBusinessUnit($businessUnit);
    }
    /**
     * Get BusinessUnit value
     * @return \App\Library\ExactTarget\StructType\BusinessUnit[]|null
     */
    public function getBusinessUnit()
    {
        return $this->BusinessUnit;
    }
    /**
     * Set BusinessUnit value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\BusinessUnit[] $businessUnit
     * @return \App\Library\ExactTarget\StructType\AssociatedBusinessUnits
     */
    public function setBusinessUnit(array $businessUnit = array())
    {
        foreach ($businessUnit as $associatedBusinessUnitsBusinessUnitItem) {
            // validation for constraint: itemType
            if (!$associatedBusinessUnitsBusinessUnitItem instanceof \App\Library\ExactTarget\StructType\BusinessUnit) {
                throw new \InvalidArgumentException(sprintf('The BusinessUnit property can only contain items of \App\Library\ExactTarget\StructType\BusinessUnit, "%s" given', is_object($associatedBusinessUnitsBusinessUnitItem) ? get_class($associatedBusinessUnitsBusinessUnitItem) : gettype($associatedBusinessUnitsBusinessUnitItem)), __LINE__);
            }
        }
        $this->BusinessUnit = $businessUnit;
        return $this;
    }
    /**
     * Add item to BusinessUnit value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\BusinessUnit $item
     * @return \App\Library\ExactTarget\StructType\AssociatedBusinessUnits
     */
    public function addToBusinessUnit(\App\Library\ExactTarget\StructType\BusinessUnit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\BusinessUnit) {
            throw new \InvalidArgumentException(sprintf('The BusinessUnit property can only contain items of \App\Library\ExactTarget\StructType\BusinessUnit, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessUnit[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AssociatedBusinessUnits
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
