<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalOperands StructType
 * @subpackage Structs
 */
class AdditionalOperands extends AbstractStructBase
{
    /**
     * The Operand
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\FilterPart[]
     */
    public $Operand;
    /**
     * Constructor method for AdditionalOperands
     * @uses AdditionalOperands::setOperand()
     * @param \App\Library\ExactTarget\StructType\FilterPart[] $operand
     */
    public function __construct(array $operand = array())
    {
        $this
            ->setOperand($operand);
    }
    /**
     * Get Operand value
     * @return \App\Library\ExactTarget\StructType\FilterPart[]|null
     */
    public function getOperand()
    {
        return $this->Operand;
    }
    /**
     * Set Operand value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\FilterPart[] $operand
     * @return \App\Library\ExactTarget\StructType\AdditionalOperands
     */
    public function setOperand(array $operand = array())
    {
        foreach ($operand as $additionalOperandsOperandItem) {
            // validation for constraint: itemType
            if (!$additionalOperandsOperandItem instanceof \App\Library\ExactTarget\StructType\FilterPart) {
                throw new \InvalidArgumentException(sprintf('The Operand property can only contain items of \App\Library\ExactTarget\StructType\FilterPart, "%s" given', is_object($additionalOperandsOperandItem) ? get_class($additionalOperandsOperandItem) : gettype($additionalOperandsOperandItem)), __LINE__);
            }
        }
        $this->Operand = $operand;
        return $this;
    }
    /**
     * Add item to Operand value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\FilterPart $item
     * @return \App\Library\ExactTarget\StructType\AdditionalOperands
     */
    public function addToOperand(\App\Library\ExactTarget\StructType\FilterPart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\FilterPart) {
            throw new \InvalidArgumentException(sprintf('The Operand property can only contain items of \App\Library\ExactTarget\StructType\FilterPart, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Operand[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AdditionalOperands
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
