<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountPrivateLabel StructType
 * @subpackage Structs
 */
class AccountPrivateLabel extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The OwnerMemberID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OwnerMemberID;
    /**
     * The ColorPaletteXML
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ColorPaletteXML;
    /**
     * Constructor method for AccountPrivateLabel
     * @uses AccountPrivateLabel::setName()
     * @uses AccountPrivateLabel::setOwnerMemberID()
     * @uses AccountPrivateLabel::setColorPaletteXML()
     * @param string $name
     * @param int $ownerMemberID
     * @param string $colorPaletteXML
     */
    public function __construct($name = null, $ownerMemberID = null, $colorPaletteXML = null)
    {
        $this
            ->setName($name)
            ->setOwnerMemberID($ownerMemberID)
            ->setColorPaletteXML($colorPaletteXML);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\AccountPrivateLabel
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get OwnerMemberID value
     * @return int
     */
    public function getOwnerMemberID()
    {
        return $this->OwnerMemberID;
    }
    /**
     * Set OwnerMemberID value
     * @param int $ownerMemberID
     * @return \App\Library\ExactTarget\StructType\AccountPrivateLabel
     */
    public function setOwnerMemberID($ownerMemberID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerMemberID) && !is_numeric($ownerMemberID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ownerMemberID)), __LINE__);
        }
        $this->OwnerMemberID = $ownerMemberID;
        return $this;
    }
    /**
     * Get ColorPaletteXML value
     * @return string
     */
    public function getColorPaletteXML()
    {
        return $this->ColorPaletteXML;
    }
    /**
     * Set ColorPaletteXML value
     * @param string $colorPaletteXML
     * @return \App\Library\ExactTarget\StructType\AccountPrivateLabel
     */
    public function setColorPaletteXML($colorPaletteXML = null)
    {
        // validation for constraint: string
        if (!is_null($colorPaletteXML) && !is_string($colorPaletteXML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($colorPaletteXML)), __LINE__);
        }
        $this->ColorPaletteXML = $colorPaletteXML;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\AccountPrivateLabel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
