<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account StructType
 * @subpackage Structs
 */
class Account extends APIObject
{
    /**
     * The AccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AccountType;
    /**
     * The ParentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ParentID;
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $BrandID;
    /**
     * The PrivateLabelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $PrivateLabelID;
    /**
     * The ReportingParentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ReportingParentID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The FromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The BusinessName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessName;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $IsActive;
    /**
     * The IsTestAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsTestAccount;
    /**
     * The OrgID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrgID;
    /**
     * The DBID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $DBID;
    /**
     * The ParentName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentName;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CustomerID;
    /**
     * The DeletedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeletedDate;
    /**
     * The EditionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $EditionID;
    /**
     * The Children
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Library\ExactTarget\StructType\AccountDataItem[]
     */
    public $Children;
    /**
     * The Subscription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Library\ExactTarget\StructType\Subscription
     */
    public $Subscription;
    /**
     * The PrivateLabels
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Library\ExactTarget\StructType\PrivateLabel[]
     */
    public $PrivateLabels;
    /**
     * The BusinessRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Library\ExactTarget\StructType\BusinessRule[]
     */
    public $BusinessRules;
    /**
     * The AccountUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Library\ExactTarget\StructType\AccountUser[]
     */
    public $AccountUsers;
    /**
     * The InheritAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $InheritAddress;
    /**
     * The IsTrialAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsTrialAccount;
    /**
     * The Locale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Locale
     */
    public $Locale;
    /**
     * The ParentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Account
     */
    public $ParentAccount;
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TimeZone
     */
    public $TimeZone;
    /**
     * The Roles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Roles
     */
    public $Roles;
    /**
     * The LanguageLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Locale
     */
    public $LanguageLocale;
    /**
     * Constructor method for Account
     * @uses Account::setAccountType()
     * @uses Account::setParentID()
     * @uses Account::setBrandID()
     * @uses Account::setPrivateLabelID()
     * @uses Account::setReportingParentID()
     * @uses Account::setName()
     * @uses Account::setEmail()
     * @uses Account::setFromName()
     * @uses Account::setBusinessName()
     * @uses Account::setPhone()
     * @uses Account::setAddress()
     * @uses Account::setFax()
     * @uses Account::setCity()
     * @uses Account::setState()
     * @uses Account::setZip()
     * @uses Account::setCountry()
     * @uses Account::setIsActive()
     * @uses Account::setIsTestAccount()
     * @uses Account::setOrgID()
     * @uses Account::setDBID()
     * @uses Account::setParentName()
     * @uses Account::setCustomerID()
     * @uses Account::setDeletedDate()
     * @uses Account::setEditionID()
     * @uses Account::setChildren()
     * @uses Account::setSubscription()
     * @uses Account::setPrivateLabels()
     * @uses Account::setBusinessRules()
     * @uses Account::setAccountUsers()
     * @uses Account::setInheritAddress()
     * @uses Account::setIsTrialAccount()
     * @uses Account::setLocale()
     * @uses Account::setParentAccount()
     * @uses Account::setTimeZone()
     * @uses Account::setRoles()
     * @uses Account::setLanguageLocale()
     * @param string $accountType
     * @param int $parentID
     * @param int $brandID
     * @param int $privateLabelID
     * @param int $reportingParentID
     * @param string $name
     * @param string $email
     * @param string $fromName
     * @param string $businessName
     * @param string $phone
     * @param string $address
     * @param string $fax
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $country
     * @param int $isActive
     * @param bool $isTestAccount
     * @param int $orgID
     * @param int $dBID
     * @param string $parentName
     * @param int $customerID
     * @param string $deletedDate
     * @param int $editionID
     * @param \App\Library\ExactTarget\StructType\AccountDataItem[] $children
     * @param \App\Library\ExactTarget\StructType\Subscription $subscription
     * @param \App\Library\ExactTarget\StructType\PrivateLabel[] $privateLabels
     * @param \App\Library\ExactTarget\StructType\BusinessRule[] $businessRules
     * @param \App\Library\ExactTarget\StructType\AccountUser[] $accountUsers
     * @param bool $inheritAddress
     * @param bool $isTrialAccount
     * @param \App\Library\ExactTarget\StructType\Locale $locale
     * @param \App\Library\ExactTarget\StructType\Account $parentAccount
     * @param \App\Library\ExactTarget\StructType\TimeZone $timeZone
     * @param \App\Library\ExactTarget\StructType\Roles $roles
     * @param \App\Library\ExactTarget\StructType\Locale $languageLocale
     */
    public function __construct($accountType = null, $parentID = null, $brandID = null, $privateLabelID = null, $reportingParentID = null, $name = null, $email = null, $fromName = null, $businessName = null, $phone = null, $address = null, $fax = null, $city = null, $state = null, $zip = null, $country = null, $isActive = null, $isTestAccount = null, $orgID = null, $dBID = null, $parentName = null, $customerID = null, $deletedDate = null, $editionID = null, array $children = array(), \App\Library\ExactTarget\StructType\Subscription $subscription = null, array $privateLabels = array(), array $businessRules = array(), array $accountUsers = array(), $inheritAddress = null, $isTrialAccount = null, \App\Library\ExactTarget\StructType\Locale $locale = null, \App\Library\ExactTarget\StructType\Account $parentAccount = null, \App\Library\ExactTarget\StructType\TimeZone $timeZone = null, \App\Library\ExactTarget\StructType\Roles $roles = null, \App\Library\ExactTarget\StructType\Locale $languageLocale = null)
    {
        $this
            ->setAccountType($accountType)
            ->setParentID($parentID)
            ->setBrandID($brandID)
            ->setPrivateLabelID($privateLabelID)
            ->setReportingParentID($reportingParentID)
            ->setName($name)
            ->setEmail($email)
            ->setFromName($fromName)
            ->setBusinessName($businessName)
            ->setPhone($phone)
            ->setAddress($address)
            ->setFax($fax)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCountry($country)
            ->setIsActive($isActive)
            ->setIsTestAccount($isTestAccount)
            ->setOrgID($orgID)
            ->setDBID($dBID)
            ->setParentName($parentName)
            ->setCustomerID($customerID)
            ->setDeletedDate($deletedDate)
            ->setEditionID($editionID)
            ->setChildren($children)
            ->setSubscription($subscription)
            ->setPrivateLabels($privateLabels)
            ->setBusinessRules($businessRules)
            ->setAccountUsers($accountUsers)
            ->setInheritAddress($inheritAddress)
            ->setIsTrialAccount($isTrialAccount)
            ->setLocale($locale)
            ->setParentAccount($parentAccount)
            ->setTimeZone($timeZone)
            ->setRoles($roles)
            ->setLanguageLocale($languageLocale);
    }
    /**
     * Get AccountType value
     * @return string
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @uses \App\Library\ExactTarget\EnumType\AccountTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\AccountTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountType
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\AccountTypeEnum::valueIsValid($accountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accountType, implode(', ', \App\Library\ExactTarget\EnumType\AccountTypeEnum::getValidValues())), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get ParentID value
     * @return int|null
     */
    public function getParentID()
    {
        return $this->ParentID;
    }
    /**
     * Set ParentID value
     * @param int $parentID
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setParentID($parentID = null)
    {
        // validation for constraint: int
        if (!is_null($parentID) && !is_numeric($parentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentID)), __LINE__);
        }
        $this->ParentID = $parentID;
        return $this;
    }
    /**
     * Get BrandID value
     * @return int|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param int $brandID
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setBrandID($brandID = null)
    {
        // validation for constraint: int
        if (!is_null($brandID) && !is_numeric($brandID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($brandID)), __LINE__);
        }
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get PrivateLabelID value
     * @return int|null
     */
    public function getPrivateLabelID()
    {
        return $this->PrivateLabelID;
    }
    /**
     * Set PrivateLabelID value
     * @param int $privateLabelID
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setPrivateLabelID($privateLabelID = null)
    {
        // validation for constraint: int
        if (!is_null($privateLabelID) && !is_numeric($privateLabelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($privateLabelID)), __LINE__);
        }
        $this->PrivateLabelID = $privateLabelID;
        return $this;
    }
    /**
     * Get ReportingParentID value
     * @return int|null
     */
    public function getReportingParentID()
    {
        return $this->ReportingParentID;
    }
    /**
     * Set ReportingParentID value
     * @param int $reportingParentID
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setReportingParentID($reportingParentID = null)
    {
        // validation for constraint: int
        if (!is_null($reportingParentID) && !is_numeric($reportingParentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reportingParentID)), __LINE__);
        }
        $this->ReportingParentID = $reportingParentID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get BusinessName value
     * @return string|null
     */
    public function getBusinessName()
    {
        return $this->BusinessName;
    }
    /**
     * Set BusinessName value
     * @param string $businessName
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setBusinessName($businessName = null)
    {
        // validation for constraint: string
        if (!is_null($businessName) && !is_string($businessName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessName)), __LINE__);
        }
        $this->BusinessName = $businessName;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get IsActive value
     * @return int|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param int $isActive
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: int
        if (!is_null($isActive) && !is_numeric($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsTestAccount value
     * @return bool|null
     */
    public function getIsTestAccount()
    {
        return $this->IsTestAccount;
    }
    /**
     * Set IsTestAccount value
     * @param bool $isTestAccount
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setIsTestAccount($isTestAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTestAccount) && !is_bool($isTestAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTestAccount)), __LINE__);
        }
        $this->IsTestAccount = $isTestAccount;
        return $this;
    }
    /**
     * Get OrgID value
     * @return int|null
     */
    public function getOrgID()
    {
        return $this->OrgID;
    }
    /**
     * Set OrgID value
     * @param int $orgID
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setOrgID($orgID = null)
    {
        // validation for constraint: int
        if (!is_null($orgID) && !is_numeric($orgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orgID)), __LINE__);
        }
        $this->OrgID = $orgID;
        return $this;
    }
    /**
     * Get DBID value
     * @return int|null
     */
    public function getDBID()
    {
        return $this->DBID;
    }
    /**
     * Set DBID value
     * @param int $dBID
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setDBID($dBID = null)
    {
        // validation for constraint: int
        if (!is_null($dBID) && !is_numeric($dBID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dBID)), __LINE__);
        }
        $this->DBID = $dBID;
        return $this;
    }
    /**
     * Get ParentName value
     * @return string|null
     */
    public function getParentName()
    {
        return $this->ParentName;
    }
    /**
     * Set ParentName value
     * @param string $parentName
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setParentName($parentName = null)
    {
        // validation for constraint: string
        if (!is_null($parentName) && !is_string($parentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentName)), __LINE__);
        }
        $this->ParentName = $parentName;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get DeletedDate value
     * @return string|null
     */
    public function getDeletedDate()
    {
        return $this->DeletedDate;
    }
    /**
     * Set DeletedDate value
     * @param string $deletedDate
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setDeletedDate($deletedDate = null)
    {
        // validation for constraint: string
        if (!is_null($deletedDate) && !is_string($deletedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deletedDate)), __LINE__);
        }
        $this->DeletedDate = $deletedDate;
        return $this;
    }
    /**
     * Get EditionID value
     * @return int|null
     */
    public function getEditionID()
    {
        return $this->EditionID;
    }
    /**
     * Set EditionID value
     * @param int $editionID
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setEditionID($editionID = null)
    {
        // validation for constraint: int
        if (!is_null($editionID) && !is_numeric($editionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($editionID)), __LINE__);
        }
        $this->EditionID = $editionID;
        return $this;
    }
    /**
     * Get Children value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Library\ExactTarget\StructType\AccountDataItem[]|null
     */
    public function getChildren()
    {
        return isset($this->Children) ? $this->Children : null;
    }
    /**
     * Set Children value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AccountDataItem[] $children
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setChildren(array $children = array())
    {
        foreach ($children as $accountChildrenItem) {
            // validation for constraint: itemType
            if (!$accountChildrenItem instanceof \App\Library\ExactTarget\StructType\AccountDataItem) {
                throw new \InvalidArgumentException(sprintf('The Children property can only contain items of \App\Library\ExactTarget\StructType\AccountDataItem, "%s" given', is_object($accountChildrenItem) ? get_class($accountChildrenItem) : gettype($accountChildrenItem)), __LINE__);
            }
        }
        if (is_null($children) || (is_array($children) && empty($children))) {
            unset($this->Children);
        } else {
            $this->Children = $children;
        }
        return $this;
    }
    /**
     * Add item to Children value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AccountDataItem $item
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function addToChildren(\App\Library\ExactTarget\StructType\AccountDataItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AccountDataItem) {
            throw new \InvalidArgumentException(sprintf('The Children property can only contain items of \App\Library\ExactTarget\StructType\AccountDataItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Children[] = $item;
        return $this;
    }
    /**
     * Get Subscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Library\ExactTarget\StructType\Subscription|null
     */
    public function getSubscription()
    {
        return isset($this->Subscription) ? $this->Subscription : null;
    }
    /**
     * Set Subscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Library\ExactTarget\StructType\Subscription $subscription
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setSubscription(\App\Library\ExactTarget\StructType\Subscription $subscription = null)
    {
        if (is_null($subscription) || (is_array($subscription) && empty($subscription))) {
            unset($this->Subscription);
        } else {
            $this->Subscription = $subscription;
        }
        return $this;
    }
    /**
     * Get PrivateLabels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Library\ExactTarget\StructType\PrivateLabel[]|null
     */
    public function getPrivateLabels()
    {
        return isset($this->PrivateLabels) ? $this->PrivateLabels : null;
    }
    /**
     * Set PrivateLabels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PrivateLabel[] $privateLabels
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setPrivateLabels(array $privateLabels = array())
    {
        foreach ($privateLabels as $accountPrivateLabelsItem) {
            // validation for constraint: itemType
            if (!$accountPrivateLabelsItem instanceof \App\Library\ExactTarget\StructType\PrivateLabel) {
                throw new \InvalidArgumentException(sprintf('The PrivateLabels property can only contain items of \App\Library\ExactTarget\StructType\PrivateLabel, "%s" given', is_object($accountPrivateLabelsItem) ? get_class($accountPrivateLabelsItem) : gettype($accountPrivateLabelsItem)), __LINE__);
            }
        }
        if (is_null($privateLabels) || (is_array($privateLabels) && empty($privateLabels))) {
            unset($this->PrivateLabels);
        } else {
            $this->PrivateLabels = $privateLabels;
        }
        return $this;
    }
    /**
     * Add item to PrivateLabels value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\PrivateLabel $item
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function addToPrivateLabels(\App\Library\ExactTarget\StructType\PrivateLabel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\PrivateLabel) {
            throw new \InvalidArgumentException(sprintf('The PrivateLabels property can only contain items of \App\Library\ExactTarget\StructType\PrivateLabel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PrivateLabels[] = $item;
        return $this;
    }
    /**
     * Get BusinessRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Library\ExactTarget\StructType\BusinessRule[]|null
     */
    public function getBusinessRules()
    {
        return isset($this->BusinessRules) ? $this->BusinessRules : null;
    }
    /**
     * Set BusinessRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\BusinessRule[] $businessRules
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setBusinessRules(array $businessRules = array())
    {
        foreach ($businessRules as $accountBusinessRulesItem) {
            // validation for constraint: itemType
            if (!$accountBusinessRulesItem instanceof \App\Library\ExactTarget\StructType\BusinessRule) {
                throw new \InvalidArgumentException(sprintf('The BusinessRules property can only contain items of \App\Library\ExactTarget\StructType\BusinessRule, "%s" given', is_object($accountBusinessRulesItem) ? get_class($accountBusinessRulesItem) : gettype($accountBusinessRulesItem)), __LINE__);
            }
        }
        if (is_null($businessRules) || (is_array($businessRules) && empty($businessRules))) {
            unset($this->BusinessRules);
        } else {
            $this->BusinessRules = $businessRules;
        }
        return $this;
    }
    /**
     * Add item to BusinessRules value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\BusinessRule $item
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function addToBusinessRules(\App\Library\ExactTarget\StructType\BusinessRule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\BusinessRule) {
            throw new \InvalidArgumentException(sprintf('The BusinessRules property can only contain items of \App\Library\ExactTarget\StructType\BusinessRule, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessRules[] = $item;
        return $this;
    }
    /**
     * Get AccountUsers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Library\ExactTarget\StructType\AccountUser[]|null
     */
    public function getAccountUsers()
    {
        return isset($this->AccountUsers) ? $this->AccountUsers : null;
    }
    /**
     * Set AccountUsers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AccountUser[] $accountUsers
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setAccountUsers(array $accountUsers = array())
    {
        foreach ($accountUsers as $accountAccountUsersItem) {
            // validation for constraint: itemType
            if (!$accountAccountUsersItem instanceof \App\Library\ExactTarget\StructType\AccountUser) {
                throw new \InvalidArgumentException(sprintf('The AccountUsers property can only contain items of \App\Library\ExactTarget\StructType\AccountUser, "%s" given', is_object($accountAccountUsersItem) ? get_class($accountAccountUsersItem) : gettype($accountAccountUsersItem)), __LINE__);
            }
        }
        if (is_null($accountUsers) || (is_array($accountUsers) && empty($accountUsers))) {
            unset($this->AccountUsers);
        } else {
            $this->AccountUsers = $accountUsers;
        }
        return $this;
    }
    /**
     * Add item to AccountUsers value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AccountUser $item
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function addToAccountUsers(\App\Library\ExactTarget\StructType\AccountUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AccountUser) {
            throw new \InvalidArgumentException(sprintf('The AccountUsers property can only contain items of \App\Library\ExactTarget\StructType\AccountUser, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountUsers[] = $item;
        return $this;
    }
    /**
     * Get InheritAddress value
     * @return bool|null
     */
    public function getInheritAddress()
    {
        return $this->InheritAddress;
    }
    /**
     * Set InheritAddress value
     * @param bool $inheritAddress
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setInheritAddress($inheritAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($inheritAddress) && !is_bool($inheritAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inheritAddress)), __LINE__);
        }
        $this->InheritAddress = $inheritAddress;
        return $this;
    }
    /**
     * Get IsTrialAccount value
     * @return bool|null
     */
    public function getIsTrialAccount()
    {
        return $this->IsTrialAccount;
    }
    /**
     * Set IsTrialAccount value
     * @param bool $isTrialAccount
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setIsTrialAccount($isTrialAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTrialAccount) && !is_bool($isTrialAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTrialAccount)), __LINE__);
        }
        $this->IsTrialAccount = $isTrialAccount;
        return $this;
    }
    /**
     * Get Locale value
     * @return \App\Library\ExactTarget\StructType\Locale|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param \App\Library\ExactTarget\StructType\Locale $locale
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setLocale(\App\Library\ExactTarget\StructType\Locale $locale = null)
    {
        $this->Locale = $locale;
        return $this;
    }
    /**
     * Get ParentAccount value
     * @return \App\Library\ExactTarget\StructType\Account|null
     */
    public function getParentAccount()
    {
        return $this->ParentAccount;
    }
    /**
     * Set ParentAccount value
     * @param \App\Library\ExactTarget\StructType\Account $parentAccount
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setParentAccount(\App\Library\ExactTarget\StructType\Account $parentAccount = null)
    {
        $this->ParentAccount = $parentAccount;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return \App\Library\ExactTarget\StructType\TimeZone|null
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param \App\Library\ExactTarget\StructType\TimeZone $timeZone
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setTimeZone(\App\Library\ExactTarget\StructType\TimeZone $timeZone = null)
    {
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Get Roles value
     * @return \App\Library\ExactTarget\StructType\Roles|null
     */
    public function getRoles()
    {
        return $this->Roles;
    }
    /**
     * Set Roles value
     * @param \App\Library\ExactTarget\StructType\Roles $roles
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setRoles(\App\Library\ExactTarget\StructType\Roles $roles = null)
    {
        $this->Roles = $roles;
        return $this;
    }
    /**
     * Get LanguageLocale value
     * @return \App\Library\ExactTarget\StructType\Locale|null
     */
    public function getLanguageLocale()
    {
        return $this->LanguageLocale;
    }
    /**
     * Set LanguageLocale value
     * @param \App\Library\ExactTarget\StructType\Locale $languageLocale
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public function setLanguageLocale(\App\Library\ExactTarget\StructType\Locale $languageLocale = null)
    {
        $this->LanguageLocale = $languageLocale;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Account
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
