<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APIObject StructType
 * @subpackage Structs
 */
class APIObject extends AbstractStructBase
{
    /**
     * The Client
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID
     */
    public $Client;
    /**
     * The PartnerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartnerKey;
    /**
     * The PartnerProperties
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $PartnerProperties;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedDate;
    /**
     * The ModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModifiedDate;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The ObjectID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ObjectID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Owner
     */
    public $Owner;
    /**
     * The CorrelationID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CorrelationID;
    /**
     * The ObjectState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObjectState;
    /**
     * Constructor method for APIObject
     * @uses APIObject::setClient()
     * @uses APIObject::setPartnerKey()
     * @uses APIObject::setPartnerProperties()
     * @uses APIObject::setCreatedDate()
     * @uses APIObject::setModifiedDate()
     * @uses APIObject::setID()
     * @uses APIObject::setObjectID()
     * @uses APIObject::setCustomerKey()
     * @uses APIObject::setOwner()
     * @uses APIObject::setCorrelationID()
     * @uses APIObject::setObjectState()
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @param string $partnerKey
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $partnerProperties
     * @param string $createdDate
     * @param string $modifiedDate
     * @param int $iD
     * @param string $objectID
     * @param string $customerKey
     * @param \App\Library\ExactTarget\StructType\Owner $owner
     * @param string $correlationID
     * @param string $objectState
     */
    public function __construct(\App\Library\ExactTarget\StructType\ClientID $client = null, $partnerKey = null, array $partnerProperties = array(), $createdDate = null, $modifiedDate = null, $iD = null, $objectID = null, $customerKey = null, \App\Library\ExactTarget\StructType\Owner $owner = null, $correlationID = null, $objectState = null)
    {
        $this
            ->setClient($client)
            ->setPartnerKey($partnerKey)
            ->setPartnerProperties($partnerProperties)
            ->setCreatedDate($createdDate)
            ->setModifiedDate($modifiedDate)
            ->setID($iD)
            ->setObjectID($objectID)
            ->setCustomerKey($customerKey)
            ->setOwner($owner)
            ->setCorrelationID($correlationID)
            ->setObjectState($objectState);
    }
    /**
     * Get Client value
     * @return \App\Library\ExactTarget\StructType\ClientID|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param \App\Library\ExactTarget\StructType\ClientID $client
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setClient(\App\Library\ExactTarget\StructType\ClientID $client = null)
    {
        $this->Client = $client;
        return $this;
    }
    /**
     * Get PartnerKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartnerKey()
    {
        return isset($this->PartnerKey) ? $this->PartnerKey : null;
    }
    /**
     * Set PartnerKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partnerKey
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setPartnerKey($partnerKey = null)
    {
        // validation for constraint: string
        if (!is_null($partnerKey) && !is_string($partnerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerKey)), __LINE__);
        }
        if (is_null($partnerKey) || (is_array($partnerKey) && empty($partnerKey))) {
            unset($this->PartnerKey);
        } else {
            $this->PartnerKey = $partnerKey;
        }
        return $this;
    }
    /**
     * Get PartnerProperties value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getPartnerProperties()
    {
        return $this->PartnerProperties;
    }
    /**
     * Set PartnerProperties value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $partnerProperties
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setPartnerProperties(array $partnerProperties = array())
    {
        foreach ($partnerProperties as $aPIObjectPartnerPropertiesItem) {
            // validation for constraint: itemType
            if (!$aPIObjectPartnerPropertiesItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The PartnerProperties property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($aPIObjectPartnerPropertiesItem) ? get_class($aPIObjectPartnerPropertiesItem) : gettype($aPIObjectPartnerPropertiesItem)), __LINE__);
            }
        }
        $this->PartnerProperties = $partnerProperties;
        return $this;
    }
    /**
     * Add item to PartnerProperties value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function addToPartnerProperties(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The PartnerProperties property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartnerProperties[] = $item;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModifiedDate()
    {
        return isset($this->ModifiedDate) ? $this->ModifiedDate : null;
    }
    /**
     * Set ModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modifiedDate
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        if (is_null($modifiedDate) || (is_array($modifiedDate) && empty($modifiedDate))) {
            unset($this->ModifiedDate);
        } else {
            $this->ModifiedDate = $modifiedDate;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ObjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectID()
    {
        return isset($this->ObjectID) ? $this->ObjectID : null;
    }
    /**
     * Set ObjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectID
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: string
        if (!is_null($objectID) && !is_string($objectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectID)), __LINE__);
        }
        if (is_null($objectID) || (is_array($objectID) && empty($objectID))) {
            unset($this->ObjectID);
        } else {
            $this->ObjectID = $objectID;
        }
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get Owner value
     * @return \App\Library\ExactTarget\StructType\Owner|null
     */
    public function getOwner()
    {
        return $this->Owner;
    }
    /**
     * Set Owner value
     * @param \App\Library\ExactTarget\StructType\Owner $owner
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setOwner(\App\Library\ExactTarget\StructType\Owner $owner = null)
    {
        $this->Owner = $owner;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setCorrelationID($correlationID = null)
    {
        // validation for constraint: string
        if (!is_null($correlationID) && !is_string($correlationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($correlationID)), __LINE__);
        }
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Get ObjectState value
     * @return string|null
     */
    public function getObjectState()
    {
        return $this->ObjectState;
    }
    /**
     * Set ObjectState value
     * @param string $objectState
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function setObjectState($objectState = null)
    {
        // validation for constraint: string
        if (!is_null($objectState) && !is_string($objectState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectState)), __LINE__);
        }
        $this->ObjectState = $objectState;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
