<?php

namespace App\Library\ExactTarget\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Update
     * Meta informations extracted from the WSDL
     * - documentation: Update objects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Library\ExactTarget\StructType\UpdateRequest $parameters
     * @return \App\Library\ExactTarget\StructType\UpdateResponse|bool
     */
    public function Update(\App\Library\ExactTarget\StructType\UpdateRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Update($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Library\ExactTarget\StructType\UpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
