<?php

namespace App\Library\ExactTarget\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Retrieve
     * Meta informations extracted from the WSDL
     * - documentation: Retrieve objects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Library\ExactTarget\StructType\RetrieveRequestMsg $parameters
     * @return \App\Library\ExactTarget\StructType\RetrieveResponseMsg|bool
     */
    public function Retrieve(\App\Library\ExactTarget\StructType\RetrieveRequestMsg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Retrieve($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Library\ExactTarget\StructType\RetrieveResponseMsg
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
