<?php

namespace App\Library\ExactTarget\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Perform ServiceType
 * @subpackage Services
 */
class Perform extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Perform
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Library\ExactTarget\StructType\PerformRequestMsg $parameters
     * @return \App\Library\ExactTarget\StructType\PerformResponseMsg|bool
     */
    public function Perform(\App\Library\ExactTarget\StructType\PerformRequestMsg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Perform($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Library\ExactTarget\StructType\PerformResponseMsg
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
