<?php

namespace App\Library\ExactTarget\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Extract ServiceType
 * @subpackage Services
 */
class Extract extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Extract
     * Meta informations extracted from the WSDL
     * - documentation: Perform ad hoc data extracts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Library\ExactTarget\StructType\ExtractRequestMsg $parameters
     * @return \App\Library\ExactTarget\StructType\ExtractResponseMsg|bool
     */
    public function Extract(\App\Library\ExactTarget\StructType\ExtractRequestMsg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Extract($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Library\ExactTarget\StructType\ExtractResponseMsg
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
