<?php

namespace App\Library\ExactTarget\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Describe ServiceType
 * @subpackage Services
 */
class Describe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Describe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Library\ExactTarget\StructType\DefinitionRequestMsg $parameters
     * @return \App\Library\ExactTarget\StructType\DefinitionResponseMsg|bool
     */
    public function Describe(\App\Library\ExactTarget\StructType\DefinitionRequestMsg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Describe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Library\ExactTarget\StructType\DefinitionResponseMsg
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
