<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for WeekOfMonthEnum EnumType
 * @subpackage Enumerations
 */
class WeekOfMonthEnum
{
    /**
     * Constant for value 'first'
     * @return string 'first'
     */
    const VALUE_FIRST = 'first';
    /**
     * Constant for value 'second'
     * @return string 'second'
     */
    const VALUE_SECOND = 'second';
    /**
     * Constant for value 'third'
     * @return string 'third'
     */
    const VALUE_THIRD = 'third';
    /**
     * Constant for value 'fourth'
     * @return string 'fourth'
     */
    const VALUE_FOURTH = 'fourth';
    /**
     * Constant for value 'last'
     * @return string 'last'
     */
    const VALUE_LAST = 'last';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIRST
     * @uses self::VALUE_SECOND
     * @uses self::VALUE_THIRD
     * @uses self::VALUE_FOURTH
     * @uses self::VALUE_LAST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIRST,
            self::VALUE_SECOND,
            self::VALUE_THIRD,
            self::VALUE_FOURTH,
            self::VALUE_LAST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
