<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for UnsubscribeBehaviorEnum EnumType
 * @subpackage Enumerations
 */
class UnsubscribeBehaviorEnum
{
    /**
     * Constant for value 'ENTIRE_ENTERPRISE'
     * @return string 'ENTIRE_ENTERPRISE'
     */
    const VALUE_ENTIRE_ENTERPRISE = 'ENTIRE_ENTERPRISE';
    /**
     * Constant for value 'BUSINESS_UNIT_ONLY'
     * @return string 'BUSINESS_UNIT_ONLY'
     */
    const VALUE_BUSINESS_UNIT_ONLY = 'BUSINESS_UNIT_ONLY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENTIRE_ENTERPRISE
     * @uses self::VALUE_BUSINESS_UNIT_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENTIRE_ENTERPRISE,
            self::VALUE_BUSINESS_UNIT_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
