<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for TriggeredSendSubClassEnum EnumType
 * @subpackage Enumerations
 */
class TriggeredSendSubClassEnum
{
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'SenderTemplate'
     * @return string 'SenderTemplate'
     */
    const VALUE_SENDER_TEMPLATE = 'SenderTemplate';
    /**
     * Constant for value 'MarketingCloudTemplate'
     * @return string 'MarketingCloudTemplate'
     */
    const VALUE_MARKETING_CLOUD_TEMPLATE = 'MarketingCloudTemplate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_SENDER_TEMPLATE
     * @uses self::VALUE_MARKETING_CLOUD_TEMPLATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_SENDER_TEMPLATE,
            self::VALUE_MARKETING_CLOUD_TEMPLATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
