<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for TriggeredSendClassEnum EnumType
 * @subpackage Enumerations
 */
class TriggeredSendClassEnum
{
    /**
     * Constant for value 'Standard'
     * @return string 'Standard'
     */
    const VALUE_STANDARD = 'Standard';
    /**
     * Constant for value 'SMTPRestV1'
     * @return string 'SMTPRestV1'
     */
    const VALUE_SMTPREST_V_1 = 'SMTPRestV1';
    /**
     * Constant for value 'SMTPRestV2'
     * @return string 'SMTPRestV2'
     */
    const VALUE_SMTPREST_V_2 = 'SMTPRestV2';
    /**
     * Constant for value 'SMTPRestV3'
     * @return string 'SMTPRestV3'
     */
    const VALUE_SMTPREST_V_3 = 'SMTPRestV3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_SMTPREST_V_1
     * @uses self::VALUE_SMTPREST_V_2
     * @uses self::VALUE_SMTPREST_V_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_SMTPREST_V_1,
            self::VALUE_SMTPREST_V_2,
            self::VALUE_SMTPREST_V_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
