<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SuppressionListContextEnum EnumType
 * @subpackage Enumerations
 */
class SuppressionListContextEnum
{
    /**
     * Constant for value 'Enterprise'
     * @return string 'Enterprise'
     */
    const VALUE_ENTERPRISE = 'Enterprise';
    /**
     * Constant for value 'BusinessUnit'
     * @return string 'BusinessUnit'
     */
    const VALUE_BUSINESS_UNIT = 'BusinessUnit';
    /**
     * Constant for value 'SendClassification'
     * @return string 'SendClassification'
     */
    const VALUE_SEND_CLASSIFICATION = 'SendClassification';
    /**
     * Constant for value 'Send'
     * @return string 'Send'
     */
    const VALUE_SEND = 'Send';
    /**
     * Constant for value 'Global'
     * @return string 'Global'
     */
    const VALUE_GLOBAL = 'Global';
    /**
     * Constant for value 'SenderProfile'
     * @return string 'SenderProfile'
     */
    const VALUE_SENDER_PROFILE = 'SenderProfile';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENTERPRISE
     * @uses self::VALUE_BUSINESS_UNIT
     * @uses self::VALUE_SEND_CLASSIFICATION
     * @uses self::VALUE_SEND
     * @uses self::VALUE_GLOBAL
     * @uses self::VALUE_SENDER_PROFILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENTERPRISE,
            self::VALUE_BUSINESS_UNIT,
            self::VALUE_SEND_CLASSIFICATION,
            self::VALUE_SEND,
            self::VALUE_GLOBAL,
            self::VALUE_SENDER_PROFILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
