<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SubscriberStatus EnumType
 * @subpackage Enumerations
 */
class SubscriberStatus
{
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Bounced'
     * @return string 'Bounced'
     */
    const VALUE_BOUNCED = 'Bounced';
    /**
     * Constant for value 'Held'
     * @return string 'Held'
     */
    const VALUE_HELD = 'Held';
    /**
     * Constant for value 'Unsubscribed'
     * @return string 'Unsubscribed'
     */
    const VALUE_UNSUBSCRIBED = 'Unsubscribed';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_BOUNCED
     * @uses self::VALUE_HELD
     * @uses self::VALUE_UNSUBSCRIBED
     * @uses self::VALUE_DELETED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_BOUNCED,
            self::VALUE_HELD,
            self::VALUE_UNSUBSCRIBED,
            self::VALUE_DELETED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
