<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SoapType EnumType
 * @subpackage Enumerations
 */
class SoapType
{
    /**
     * Constant for value 'xsd:string'
     * @return string 'xsd:string'
     */
    const VALUE_XSD_STRING = 'xsd:string';
    /**
     * Constant for value 'xsd:boolean'
     * @return string 'xsd:boolean'
     */
    const VALUE_XSD_BOOLEAN = 'xsd:boolean';
    /**
     * Constant for value 'xsd:double'
     * @return string 'xsd:double'
     */
    const VALUE_XSD_DOUBLE = 'xsd:double';
    /**
     * Constant for value 'xsd:dateTime'
     * @return string 'xsd:dateTime'
     */
    const VALUE_XSD_DATE_TIME = 'xsd:dateTime';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_XSD_STRING
     * @uses self::VALUE_XSD_BOOLEAN
     * @uses self::VALUE_XSD_DOUBLE
     * @uses self::VALUE_XSD_DATE_TIME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_XSD_STRING,
            self::VALUE_XSD_BOOLEAN,
            self::VALUE_XSD_DOUBLE,
            self::VALUE_XSD_DATE_TIME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
