<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SimpleOperators EnumType
 * @subpackage Enumerations
 */
class SimpleOperators
{
    /**
     * Constant for value 'equals'
     * @return string 'equals'
     */
    const VALUE_EQUALS = 'equals';
    /**
     * Constant for value 'notEquals'
     * @return string 'notEquals'
     */
    const VALUE_NOT_EQUALS = 'notEquals';
    /**
     * Constant for value 'greaterThan'
     * @return string 'greaterThan'
     */
    const VALUE_GREATER_THAN = 'greaterThan';
    /**
     * Constant for value 'lessThan'
     * @return string 'lessThan'
     */
    const VALUE_LESS_THAN = 'lessThan';
    /**
     * Constant for value 'isNull'
     * @return string 'isNull'
     */
    const VALUE_IS_NULL = 'isNull';
    /**
     * Constant for value 'isNotNull'
     * @return string 'isNotNull'
     */
    const VALUE_IS_NOT_NULL = 'isNotNull';
    /**
     * Constant for value 'greaterThanOrEqual'
     * @return string 'greaterThanOrEqual'
     */
    const VALUE_GREATER_THAN_OR_EQUAL = 'greaterThanOrEqual';
    /**
     * Constant for value 'lessThanOrEqual'
     * @return string 'lessThanOrEqual'
     */
    const VALUE_LESS_THAN_OR_EQUAL = 'lessThanOrEqual';
    /**
     * Constant for value 'between'
     * @return string 'between'
     */
    const VALUE_BETWEEN = 'between';
    /**
     * Constant for value 'IN'
     * @return string 'IN'
     */
    const VALUE_IN = 'IN';
    /**
     * Constant for value 'like'
     * @return string 'like'
     */
    const VALUE_LIKE = 'like';
    /**
     * Constant for value 'existsInString'
     * @return string 'existsInString'
     */
    const VALUE_EXISTS_IN_STRING = 'existsInString';
    /**
     * Constant for value 'existsInStringAsAWord'
     * @return string 'existsInStringAsAWord'
     */
    const VALUE_EXISTS_IN_STRING_AS_AWORD = 'existsInStringAsAWord';
    /**
     * Constant for value 'notExistsInString'
     * @return string 'notExistsInString'
     */
    const VALUE_NOT_EXISTS_IN_STRING = 'notExistsInString';
    /**
     * Constant for value 'beginsWith'
     * @return string 'beginsWith'
     */
    const VALUE_BEGINS_WITH = 'beginsWith';
    /**
     * Constant for value 'endsWith'
     * @return string 'endsWith'
     */
    const VALUE_ENDS_WITH = 'endsWith';
    /**
     * Constant for value 'contains'
     * @return string 'contains'
     */
    const VALUE_CONTAINS = 'contains';
    /**
     * Constant for value 'notContains'
     * @return string 'notContains'
     */
    const VALUE_NOT_CONTAINS = 'notContains';
    /**
     * Constant for value 'isAnniversary'
     * @return string 'isAnniversary'
     */
    const VALUE_IS_ANNIVERSARY = 'isAnniversary';
    /**
     * Constant for value 'isNotAnniversary'
     * @return string 'isNotAnniversary'
     */
    const VALUE_IS_NOT_ANNIVERSARY = 'isNotAnniversary';
    /**
     * Constant for value 'greaterThanAnniversary'
     * @return string 'greaterThanAnniversary'
     */
    const VALUE_GREATER_THAN_ANNIVERSARY = 'greaterThanAnniversary';
    /**
     * Constant for value 'lessThanAnniversary'
     * @return string 'lessThanAnniversary'
     */
    const VALUE_LESS_THAN_ANNIVERSARY = 'lessThanAnniversary';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EQUALS
     * @uses self::VALUE_NOT_EQUALS
     * @uses self::VALUE_GREATER_THAN
     * @uses self::VALUE_LESS_THAN
     * @uses self::VALUE_IS_NULL
     * @uses self::VALUE_IS_NOT_NULL
     * @uses self::VALUE_GREATER_THAN_OR_EQUAL
     * @uses self::VALUE_LESS_THAN_OR_EQUAL
     * @uses self::VALUE_BETWEEN
     * @uses self::VALUE_IN
     * @uses self::VALUE_LIKE
     * @uses self::VALUE_EXISTS_IN_STRING
     * @uses self::VALUE_EXISTS_IN_STRING_AS_AWORD
     * @uses self::VALUE_NOT_EXISTS_IN_STRING
     * @uses self::VALUE_BEGINS_WITH
     * @uses self::VALUE_ENDS_WITH
     * @uses self::VALUE_CONTAINS
     * @uses self::VALUE_NOT_CONTAINS
     * @uses self::VALUE_IS_ANNIVERSARY
     * @uses self::VALUE_IS_NOT_ANNIVERSARY
     * @uses self::VALUE_GREATER_THAN_ANNIVERSARY
     * @uses self::VALUE_LESS_THAN_ANNIVERSARY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUALS,
            self::VALUE_NOT_EQUALS,
            self::VALUE_GREATER_THAN,
            self::VALUE_LESS_THAN,
            self::VALUE_IS_NULL,
            self::VALUE_IS_NOT_NULL,
            self::VALUE_GREATER_THAN_OR_EQUAL,
            self::VALUE_LESS_THAN_OR_EQUAL,
            self::VALUE_BETWEEN,
            self::VALUE_IN,
            self::VALUE_LIKE,
            self::VALUE_EXISTS_IN_STRING,
            self::VALUE_EXISTS_IN_STRING_AS_AWORD,
            self::VALUE_NOT_EXISTS_IN_STRING,
            self::VALUE_BEGINS_WITH,
            self::VALUE_ENDS_WITH,
            self::VALUE_CONTAINS,
            self::VALUE_NOT_CONTAINS,
            self::VALUE_IS_ANNIVERSARY,
            self::VALUE_IS_NOT_ANNIVERSARY,
            self::VALUE_GREATER_THAN_ANNIVERSARY,
            self::VALUE_LESS_THAN_ANNIVERSARY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
