<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SendDefinitionListTypeEnum EnumType
 * @subpackage Enumerations
 */
class SendDefinitionListTypeEnum
{
    /**
     * Constant for value 'SourceList'
     * @return string 'SourceList'
     */
    const VALUE_SOURCE_LIST = 'SourceList';
    /**
     * Constant for value 'ExclusionList'
     * @return string 'ExclusionList'
     */
    const VALUE_EXCLUSION_LIST = 'ExclusionList';
    /**
     * Constant for value 'DomainExclusion'
     * @return string 'DomainExclusion'
     */
    const VALUE_DOMAIN_EXCLUSION = 'DomainExclusion';
    /**
     * Constant for value 'OptOutList'
     * @return string 'OptOutList'
     */
    const VALUE_OPT_OUT_LIST = 'OptOutList';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SOURCE_LIST
     * @uses self::VALUE_EXCLUSION_LIST
     * @uses self::VALUE_DOMAIN_EXCLUSION
     * @uses self::VALUE_OPT_OUT_LIST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOURCE_LIST,
            self::VALUE_EXCLUSION_LIST,
            self::VALUE_DOMAIN_EXCLUSION,
            self::VALUE_OPT_OUT_LIST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
