<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SendClassificationTypeEnum EnumType
 * @subpackage Enumerations
 */
class SendClassificationTypeEnum
{
    /**
     * Constant for value 'Operational'
     * @return string 'Operational'
     */
    const VALUE_OPERATIONAL = 'Operational';
    /**
     * Constant for value 'Marketing'
     * @return string 'Marketing'
     */
    const VALUE_MARKETING = 'Marketing';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OPERATIONAL
     * @uses self::VALUE_MARKETING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OPERATIONAL,
            self::VALUE_MARKETING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
