<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for SaveAction EnumType
 * @subpackage Enumerations
 */
class SaveAction
{
    /**
     * Constant for value 'AddOnly'
     * @return string 'AddOnly'
     */
    const VALUE_ADD_ONLY = 'AddOnly';
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Nothing'
     * @return string 'Nothing'
     */
    const VALUE_NOTHING = 'Nothing';
    /**
     * Constant for value 'UpdateAdd'
     * @return string 'UpdateAdd'
     */
    const VALUE_UPDATE_ADD = 'UpdateAdd';
    /**
     * Constant for value 'UpdateOnly'
     * @return string 'UpdateOnly'
     */
    const VALUE_UPDATE_ONLY = 'UpdateOnly';
    /**
     * Constant for value 'Delete'
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD_ONLY
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_NOTHING
     * @uses self::VALUE_UPDATE_ADD
     * @uses self::VALUE_UPDATE_ONLY
     * @uses self::VALUE_DELETE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD_ONLY,
            self::VALUE_DEFAULT,
            self::VALUE_NOTHING,
            self::VALUE_UPDATE_ADD,
            self::VALUE_UPDATE_ONLY,
            self::VALUE_DELETE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
