<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for RequestType EnumType
 * @subpackage Enumerations
 */
class RequestType
{
    /**
     * Constant for value 'Synchronous'
     * @return string 'Synchronous'
     */
    const VALUE_SYNCHRONOUS = 'Synchronous';
    /**
     * Constant for value 'Asynchronous'
     * @return string 'Asynchronous'
     */
    const VALUE_ASYNCHRONOUS = 'Asynchronous';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SYNCHRONOUS
     * @uses self::VALUE_ASYNCHRONOUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SYNCHRONOUS,
            self::VALUE_ASYNCHRONOUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
