<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for RecurrenceTypeEnum EnumType
 * @subpackage Enumerations
 */
class RecurrenceTypeEnum
{
    /**
     * Constant for value 'Secondly'
     * @return string 'Secondly'
     */
    const VALUE_SECONDLY = 'Secondly';
    /**
     * Constant for value 'Minutely'
     * @return string 'Minutely'
     */
    const VALUE_MINUTELY = 'Minutely';
    /**
     * Constant for value 'Hourly'
     * @return string 'Hourly'
     */
    const VALUE_HOURLY = 'Hourly';
    /**
     * Constant for value 'Daily'
     * @return string 'Daily'
     */
    const VALUE_DAILY = 'Daily';
    /**
     * Constant for value 'Weekly'
     * @return string 'Weekly'
     */
    const VALUE_WEEKLY = 'Weekly';
    /**
     * Constant for value 'Monthly'
     * @return string 'Monthly'
     */
    const VALUE_MONTHLY = 'Monthly';
    /**
     * Constant for value 'Yearly'
     * @return string 'Yearly'
     */
    const VALUE_YEARLY = 'Yearly';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SECONDLY
     * @uses self::VALUE_MINUTELY
     * @uses self::VALUE_HOURLY
     * @uses self::VALUE_DAILY
     * @uses self::VALUE_WEEKLY
     * @uses self::VALUE_MONTHLY
     * @uses self::VALUE_YEARLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SECONDLY,
            self::VALUE_MINUTELY,
            self::VALUE_HOURLY,
            self::VALUE_DAILY,
            self::VALUE_WEEKLY,
            self::VALUE_MONTHLY,
            self::VALUE_YEARLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
