<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for RecurrenceRangeTypeEnum EnumType
 * @subpackage Enumerations
 */
class RecurrenceRangeTypeEnum
{
    /**
     * Constant for value 'EndAfter'
     * @return string 'EndAfter'
     */
    const VALUE_END_AFTER = 'EndAfter';
    /**
     * Constant for value 'EndOn'
     * @return string 'EndOn'
     */
    const VALUE_END_ON = 'EndOn';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_END_AFTER
     * @uses self::VALUE_END_ON
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_END_AFTER,
            self::VALUE_END_ON,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
