<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for MonthlyRecurrencePatternTypeEnum EnumType
 * @subpackage Enumerations
 */
class MonthlyRecurrencePatternTypeEnum
{
    /**
     * Constant for value 'ByDay'
     * @return string 'ByDay'
     */
    const VALUE_BY_DAY = 'ByDay';
    /**
     * Constant for value 'ByWeek'
     * @return string 'ByWeek'
     */
    const VALUE_BY_WEEK = 'ByWeek';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BY_DAY
     * @uses self::VALUE_BY_WEEK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BY_DAY,
            self::VALUE_BY_WEEK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
