<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for ListTypeEnum EnumType
 * @subpackage Enumerations
 */
class ListTypeEnum
{
    /**
     * Constant for value 'Public'
     * @return string 'Public'
     */
    const VALUE_PUBLIC = 'Public';
    /**
     * Constant for value 'Private'
     * @return string 'Private'
     */
    const VALUE_PRIVATE = 'Private';
    /**
     * Constant for value 'SalesForce'
     * @return string 'SalesForce'
     */
    const VALUE_SALES_FORCE = 'SalesForce';
    /**
     * Constant for value 'GlobalUnsubscribe'
     * @return string 'GlobalUnsubscribe'
     */
    const VALUE_GLOBAL_UNSUBSCRIBE = 'GlobalUnsubscribe';
    /**
     * Constant for value 'Master'
     * @return string 'Master'
     */
    const VALUE_MASTER = 'Master';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PUBLIC
     * @uses self::VALUE_PRIVATE
     * @uses self::VALUE_SALES_FORCE
     * @uses self::VALUE_GLOBAL_UNSUBSCRIBE
     * @uses self::VALUE_MASTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PUBLIC,
            self::VALUE_PRIVATE,
            self::VALUE_SALES_FORCE,
            self::VALUE_GLOBAL_UNSUBSCRIBE,
            self::VALUE_MASTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
