<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for ExtractParameterDataType EnumType
 * @subpackage Enumerations
 */
class ExtractParameterDataType
{
    /**
     * Constant for value 'datetime'
     * @return string 'datetime'
     */
    const VALUE_DATETIME = 'datetime';
    /**
     * Constant for value 'bool'
     * @return string 'bool'
     */
    const VALUE_BOOL = 'bool';
    /**
     * Constant for value 'string'
     * @return string 'string'
     */
    const VALUE_STRING = 'string';
    /**
     * Constant for value 'integer'
     * @return string 'integer'
     */
    const VALUE_INTEGER = 'integer';
    /**
     * Constant for value 'dropdown'
     * @return string 'dropdown'
     */
    const VALUE_DROPDOWN = 'dropdown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DATETIME
     * @uses self::VALUE_BOOL
     * @uses self::VALUE_STRING
     * @uses self::VALUE_INTEGER
     * @uses self::VALUE_DROPDOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DATETIME,
            self::VALUE_BOOL,
            self::VALUE_STRING,
            self::VALUE_INTEGER,
            self::VALUE_DROPDOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
