<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for EmailType EnumType
 * @subpackage Enumerations
 */
class EmailType
{
    /**
     * Constant for value 'Text'
     * @return string 'Text'
     */
    const VALUE_TEXT = 'Text';
    /**
     * Constant for value 'HTML'
     * @return string 'HTML'
     */
    const VALUE_HTML = 'HTML';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEXT
     * @uses self::VALUE_HTML
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEXT,
            self::VALUE_HTML,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
