<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for DeliveryProfileSourceAddressTypeEnum EnumType
 * @subpackage Enumerations
 */
class DeliveryProfileSourceAddressTypeEnum
{
    /**
     * Constant for value 'DefaultPrivateIPAddress'
     * @return string 'DefaultPrivateIPAddress'
     */
    const VALUE_DEFAULT_PRIVATE_IPADDRESS = 'DefaultPrivateIPAddress';
    /**
     * Constant for value 'CustomPrivateIPAddress'
     * @return string 'CustomPrivateIPAddress'
     */
    const VALUE_CUSTOM_PRIVATE_IPADDRESS = 'CustomPrivateIPAddress';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT_PRIVATE_IPADDRESS
     * @uses self::VALUE_CUSTOM_PRIVATE_IPADDRESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT_PRIVATE_IPADDRESS,
            self::VALUE_CUSTOM_PRIVATE_IPADDRESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
