<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for DateTimeUnitOfMeasure EnumType
 * @subpackage Enumerations
 */
class DateTimeUnitOfMeasure
{
    /**
     * Constant for value 'Days'
     * @return string 'Days'
     */
    const VALUE_DAYS = 'Days';
    /**
     * Constant for value 'Weeks'
     * @return string 'Weeks'
     */
    const VALUE_WEEKS = 'Weeks';
    /**
     * Constant for value 'Months'
     * @return string 'Months'
     */
    const VALUE_MONTHS = 'Months';
    /**
     * Constant for value 'Years'
     * @return string 'Years'
     */
    const VALUE_YEARS = 'Years';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAYS
     * @uses self::VALUE_WEEKS
     * @uses self::VALUE_MONTHS
     * @uses self::VALUE_YEARS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAYS,
            self::VALUE_WEEKS,
            self::VALUE_MONTHS,
            self::VALUE_YEARS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
