<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for DataSourceTypeEnum EnumType
 * @subpackage Enumerations
 */
class DataSourceTypeEnum
{
    /**
     * Constant for value 'List'
     * @return string 'List'
     */
    const VALUE_LIST = 'List';
    /**
     * Constant for value 'CustomObject'
     * @return string 'CustomObject'
     */
    const VALUE_CUSTOM_OBJECT = 'CustomObject';
    /**
     * Constant for value 'DomainExclusion'
     * @return string 'DomainExclusion'
     */
    const VALUE_DOMAIN_EXCLUSION = 'DomainExclusion';
    /**
     * Constant for value 'SalesForceReport'
     * @return string 'SalesForceReport'
     */
    const VALUE_SALES_FORCE_REPORT = 'SalesForceReport';
    /**
     * Constant for value 'SalesForceCampaign'
     * @return string 'SalesForceCampaign'
     */
    const VALUE_SALES_FORCE_CAMPAIGN = 'SalesForceCampaign';
    /**
     * Constant for value 'FilterDefinition'
     * @return string 'FilterDefinition'
     */
    const VALUE_FILTER_DEFINITION = 'FilterDefinition';
    /**
     * Constant for value 'OptOutList'
     * @return string 'OptOutList'
     */
    const VALUE_OPT_OUT_LIST = 'OptOutList';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LIST
     * @uses self::VALUE_CUSTOM_OBJECT
     * @uses self::VALUE_DOMAIN_EXCLUSION
     * @uses self::VALUE_SALES_FORCE_REPORT
     * @uses self::VALUE_SALES_FORCE_CAMPAIGN
     * @uses self::VALUE_FILTER_DEFINITION
     * @uses self::VALUE_OPT_OUT_LIST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LIST,
            self::VALUE_CUSTOM_OBJECT,
            self::VALUE_DOMAIN_EXCLUSION,
            self::VALUE_SALES_FORCE_REPORT,
            self::VALUE_SALES_FORCE_CAMPAIGN,
            self::VALUE_FILTER_DEFINITION,
            self::VALUE_OPT_OUT_LIST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
