<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for DataExtensionFieldType EnumType
 * @subpackage Enumerations
 */
class DataExtensionFieldType
{
    /**
     * Constant for value 'Text'
     * @return string 'Text'
     */
    const VALUE_TEXT = 'Text';
    /**
     * Constant for value 'Number'
     * @return string 'Number'
     */
    const VALUE_NUMBER = 'Number';
    /**
     * Constant for value 'Date'
     * @return string 'Date'
     */
    const VALUE_DATE = 'Date';
    /**
     * Constant for value 'Boolean'
     * @return string 'Boolean'
     */
    const VALUE_BOOLEAN = 'Boolean';
    /**
     * Constant for value 'EmailAddress'
     * @return string 'EmailAddress'
     */
    const VALUE_EMAIL_ADDRESS = 'EmailAddress';
    /**
     * Constant for value 'Phone'
     * @return string 'Phone'
     */
    const VALUE_PHONE = 'Phone';
    /**
     * Constant for value 'Decimal'
     * @return string 'Decimal'
     */
    const VALUE_DECIMAL = 'Decimal';
    /**
     * Constant for value 'Locale'
     * @return string 'Locale'
     */
    const VALUE_LOCALE = 'Locale';
    /**
     * Constant for value 'Base16Encrypted'
     * @return string 'Base16Encrypted'
     */
    const VALUE_BASE_16_ENCRYPTED = 'Base16Encrypted';
    /**
     * Constant for value 'Base16EncryptedEmail'
     * @return string 'Base16EncryptedEmail'
     */
    const VALUE_BASE_16_ENCRYPTED_EMAIL = 'Base16EncryptedEmail';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEXT
     * @uses self::VALUE_NUMBER
     * @uses self::VALUE_DATE
     * @uses self::VALUE_BOOLEAN
     * @uses self::VALUE_EMAIL_ADDRESS
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_DECIMAL
     * @uses self::VALUE_LOCALE
     * @uses self::VALUE_BASE_16_ENCRYPTED
     * @uses self::VALUE_BASE_16_ENCRYPTED_EMAIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEXT,
            self::VALUE_NUMBER,
            self::VALUE_DATE,
            self::VALUE_BOOLEAN,
            self::VALUE_EMAIL_ADDRESS,
            self::VALUE_PHONE,
            self::VALUE_DECIMAL,
            self::VALUE_LOCALE,
            self::VALUE_BASE_16_ENCRYPTED,
            self::VALUE_BASE_16_ENCRYPTED_EMAIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
